const addressModel = require('../models/addressModel');
const bcryptjs = require('bcryptjs');
const jwt = require('jsonwebtoken');
const multer = require('multer');
const path = require('path');
const axios = require('axios');
const fs = require('fs');

const city = async(req, res) =>{

    try{
        const cityDetails = await addressModel.city();
        var data = {
            "status": "1",
            "message":"city list",
            "data":cityDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'city not found' });
    }

}

const society = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const societyDetails = await addressModel.society(appDetatils);
        var data = {
            "status": "1",
            "message":"Society list",
            "data":societyDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'Society not found' });
    }

    
}

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, 'doorimage/');
    //cb(null, 'https://quickart.ae/adminDev/images/profile_image/');
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname));
  }
});

const upload = multer({ dest: 'doorimage/' }); // Temporary storage for uploaded files

const uploadImage = async (req, res) => {

    try {
        const file = req.file;
        const body = req.body;
       
        // if (!file) {
        // res.status(500).json({ message: 'No file uploaded'});
        // }
        
        if(file){
            const date = new Date().toISOString().slice(0, 10); // Format as YYYY-MM-DD
            const time = Date.now(); // Unique timestamp for filename
            const fileName = file.originalname; // Original file name
    
            // Construct file path
             filePath = `images/doorimage/${date}/${time}_${fileName}`;
            const fileFullPath = `doorimage/${file.filename}`; // Path to the temporarily stored file
    
            // Upload the file to Bunny.net
            const url = `https://sg.storage.bunnycdn.com/quickart/${filePath}`;
            const response = await axios.put(url, fs.createReadStream(fileFullPath), {
                headers: {
                    AccessKey:"d6822d0a-db42-4b2b-b926261b56b0-e522-4650",
                    'Content-Type': 'application/octet-stream',
                },
            });
            
              // Remove file from temp storage
                fs.unlink(fileFullPath, (err) => {
                    if (err) {
                        console.error('Error deleting temp file:', err);
                    } else {
                        console.log('Temp file deleted:', fileFullPath);
                    }
                });
       
            
        }else{
            filePath = null;
        }
        
        
       
        
      // Initialize imageData with common fields
          const imageData = {
            user_id: body.user_id,
            type: body.type,
            receiver_name:body.receiver_name,
            receiver_phone:body.receiver_phone,
            receiver_phone_code:body.receiver_phone_code,
            receiver_email:body.receiver_email,
            society_name:body.society_name,
            house_no:body.house_no,
            landmark:body.landmark,
            lat:body.lat,
            lng:body.lng,
            dial_code:body.dial_code,
            path:filePath
          };
       
         const newImage = await addressModel.addAddress(imageData);
      
          res.status(201).json({ message: 'Data saved successfully',
              data: imageData
          });

    } catch (error) {
        console.error('Error uploading file:', error);
        res.status(500).json({ message: 'An error occurred while uploading the file.'});
    }
};

const uploadedaddImage = async (req, res) => {
    try {
        const file = req.file;
        const body = req.body;

        // if (!file) {
        //     return res.status(400).json({ message: 'No file uploaded' });
        // }
        
        if(file){
            // If file exists, process it
            const date = new Date().toISOString().slice(0, 10); // Format as YYYY-MM-DD
            const time = Date.now(); // Unique timestamp for filename
            const fileName = file.originalname; // Original file name
    
            // Construct file path for Bunny.net storage
             filePath = `images/doorimage/${date}/${time}_${fileName}`;
            const fileFullPath = `doorimage/${file.filename}`; // Local path to the uploaded file
    
            // Upload the file to Bunny.net
            const url = `https://sg.storage.bunnycdn.com/quickart/${filePath}`;
            const response = await axios.put(url, fs.createReadStream(fileFullPath), {
                headers: {
                    AccessKey: "d6822d0a-db42-4b2b-b926261b56b0-e522-4650", // Replace with your actual Bunny.net AccessKey
                    'Content-Type': 'application/octet-stream',
                },
            });
            
              // Remove file from temp storage
                fs.unlink(fileFullPath, (err) => {
                    if (err) {
                        console.error('Error deleting temp file:', err);
                    } else {
                        console.log('Temp file deleted:', fileFullPath);
                    }
                });
        
        }else{
            filePath = null;
        }

        // If the file upload is successful, store the image data
        const imageData = {
            user_id: body.user_id,
            type: body.type,
            receiver_name: body.receiver_name,
            receiver_phone: body.receiver_phone,
            receiver_phone_code: body.receiver_phone_code,
            receiver_email: body.receiver_email,
            society_name: body.society_name,
            house_no: body.house_no,
            landmark: body.landmark,
            lat: body.lat,
            lng: body.lng,
            dial_code: body.dial_code,
            address_id:body.address_id,
            path: filePath, // The full URL to the uploaded file
        };

        // Save the data to the database or any further operations
        if (imageData.type === 'Home') {
        const checkaddresshome = await addressModel.checkaddresshome(imageData);
        if (checkaddresshome.length > 0) {
        return res.status(201).json({
        message: "You've already added a Home address. Please choose another address type.",
        });   
        }
        }

        
        
        const newImage = await addressModel.editAddress(imageData);
        // Send a response back to the client
        res.status(201).json({
        message: 'Data saved successfully',
        data: imageData,
        });


    } catch (error) {
        console.error('Error uploading file:', error);
        res.status(500).json({ status: 0, message: error.message  });
    }
};

const uploaddoorImage = async (req, res) => {
    try {
        const file = req.file;
        const body = req.body;

        // if (!file) {
        //     return res.status(400).json({ message: 'No file uploaded' });
        // }
        
        if(file){
            // If file exists, process it
            const date = new Date().toISOString().slice(0, 10); // Format as YYYY-MM-DD
            const time = Date.now(); // Unique timestamp for filename
            const fileName = file.originalname; // Original file name
    
            // Construct file path for Bunny.net storage
             filePath = `images/doorimage/${date}/${time}_${fileName}`;
            const fileFullPath = `doorimage/${file.filename}`; // Local path to the uploaded file
    
            // Upload the file to Bunny.net
            const url = `https://sg.storage.bunnycdn.com/quickart/${filePath}`;
            const response = await axios.put(url, fs.createReadStream(fileFullPath), {
                headers: {
                    AccessKey: "d6822d0a-db42-4b2b-b926261b56b0-e522-4650", // Replace with your actual Bunny.net AccessKey
                    'Content-Type': 'application/octet-stream',
                },
            });
            
              // Remove file from temp storage
                fs.unlink(fileFullPath, (err) => {
                    if (err) {
                        console.error('Error deleting temp file:', err);
                    } else {
                        console.log('Temp file deleted:', fileFullPath);
                    }
                });
        
        }else{
            filePath = null;
        }

        // If the file upload is successful, store the image data
        const imageData = {
            user_id: body.user_id,
            address_id:body.address_id,
            path: filePath, // The full URL to the uploaded file
        };

        // Save the data to the database or any further operations
        const newImage = await addressModel.doorimage(imageData);

        // Send a response back to the client
        res.status(201).json({
            message: 'Data saved successfully',
            data: imageData,
        });

    } catch (error) {
        console.error('Error uploading file:', error);
        res.status(500).json({ message: 'An error occurred while uploading the file.' });
    }
};

const add_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.addAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Saved",
          // "data": addressDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        // res.status(500).json({ status: 0, message: 'something went wrong' });
        res.status(500).json({ status: 0, message: error.message  });
    }

}

const remove_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.removeAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Removed"
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'Try Again Later' });
    }

}

const show_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.showAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address list",
            "data": addressDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'something went wrong' });
    }

}

const edit_add = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.editAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Updated"
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'something went wrong' });
    }

}

module.exports = {
    add_address,
    show_address,
    remove_address,
    edit_add,
    city,
    society,
    storage,
    upload,
    uploadImage,
    uploadedaddImage,
    uploaddoorImage
  };