// controllers/categoryController.js
const userModel = require('../models/userModel');
const homeappModel = require('../models/homeappModel');
const productlistModel = require('../models/productlistModel');
const knex = require('../db'); // Import your Knex instance

const oneapi = async (req, res) => {

    try {
      const appDetatils = req.body; 
      const bannerList = await homeappModel.getBanner(appDetatils);
       //const bannerList = [];
      const topCat = await homeappModel.getTopCat(appDetatils);
    //  const whatsNew = await homeappModel.getWhatsNew(appDetatils);
      // const dealProduct = await homeappModel.getdealProduct(appDetatils);
      const secondBanner = await homeappModel.getsecondBanner(appDetatils);
      const specialOfferBanner = await homeappModel.specialOfferBanner(appDetatils);
      const sneakyOfferBanner  = await homeappModel.sneakyOfferBanner(appDetatils);
      const popupBanner  = await homeappModel.popupBanner(appDetatils);
      const recentSelling = await homeappModel.getrecentSelling(appDetatils);
      const topSelling = await homeappModel.gettopSelling(appDetatils);
      const additionalCategory = await homeappModel.getadditionalCategory(appDetatils);
      const orderlist = await homeappModel.getorderList(appDetatils);
      const baseurl =  process.env.BUNNY_NET_IMAGE;
      const imgurl =  process.env.base_url;
      const brandList = await homeappModel.getBrand(appDetatils);
      const occasionalCategory = await homeappModel.getoccasionalCategory(appDetatils);
      const featurecategory  = await homeappModel.getfeaturecat(appDetatils);
      const activesub_ordlist  = await homeappModel.getactivesubord(appDetatils);
      const trailpackimage = await homeappModel.trailpackimagedata(appDetatils);
      
      const bgimage = await knex('app_settings')
          .where('store_id', 7)
          .select('bg_image_color', knex.raw(`CONCAT('${imgurl}', home_bg_image) as home_bg_image`))
          .first();
    //   const subscriptonDetails = await homeappModel.getsubscriptonDetails(appDetatils);
    
      
        var data =  {
        "status": "1",
        "message": "Homepage data",
        "popupdata": "",
        "orderlist":orderlist,
        "banner":bannerList,
        "top_cat":topCat,
        // "category":null,
       // "whatsnew":whatsNew,
        // "dealproduct":dealProduct,
        "second_banner":secondBanner,
        "special_offer_banner":specialOfferBanner,
        "sneaky_banner":sneakyOfferBanner,
        "popup_banner":popupBanner,
        "recentselling":recentSelling,
        "topselling":topSelling,
        // "spotlight":null,
        // "subscripton_details":null,
        "additional_category":additionalCategory,
        "occasionalCategory":occasionalCategory,
        "brand":brandList,
        "activesub_ordlist":activesub_ordlist,
        //"oneapi_bg_first_image": baseurl + "/images/quickart-ramadan-demo.gif",
        "oneapi_bg_first_image": bgimage,
        "featurecategory":featurecategory,
        "trailpackimage":trailpackimage
       // "activesub_ordlist":activesub_ordlist
        };
    res.status(200).json(data);
    } catch (error) {
      console.error(error);
      res.status(500).json({ status: 0,message: 'Internal Server Error' });
    }
};

const cat_product = async (req, res) => {
    try{
      const appDetatils = req.body;   
      const product = await homeappModel.getcatProduct(appDetatils);
      var data = {
        "status": "1",
        "message": "Products found",
        "data":product
        };
    res.status(200).json(data);

    } catch(error){
      console.error(error);
      res.status(500).json({ status: 0, message: 'Products not found' });
    }
};

const featurecat_prod = async (req, res) => {
  try{
    const appDetatils = req.body;   
    const product = await homeappModel.getfetcatProd(appDetatils);
    var data = {
      "status": "1",
      "message": "Products List",
      "data":product
      };
  res.status(200).json(data);

  } catch(error){
    console.error(error);
    res.status(500).json({ status: 0, message: 'Products not found' });
  }
};

const product_det = async (req, res) => {
      try{
        const appDetatils = req.body;   
        const productDetails = await homeappModel.prodDetails(appDetatils);
        let catId = await knex('product').where('product_id', appDetatils.product_id).select('cat_id').first();
        const similarProds = await homeappModel.similarProds(appDetatils,catId.cat_id);

        var data = {
          "status": "1",
          "message": "Products Detail",
          "detail":productDetails,
          "similar_product":similarProds
          
          };
      res.status(200).json(data);
  

      }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: error.message  });
      }
};

const catee = async (req, res) => {

    try {
      const appDetatils = req.body; 
      const categoryList = await homeappModel.getcategoryList(appDetatils);

        var data = {
        "status": "1",
        "message": "data found",
        "data":categoryList,
        
        };
    res.status(200).json(data);
    } catch (error) {
      console.error(error);
      res.status(500).json({ status: 0, message: 'Internal Server Error' });
    }
};

const brand_list = async(req, res) => {
    try {
    
      const brandList = await homeappModel.getBrandlist();

        var data = {
       "status": "1",
        "message": "data found",
        "data":brandList,
        
        };
    res.status(200).json(data);
    } catch (error) {
     

     
        console.error(error);
        res.status(500).json({ message: 'Internal Server Error' });
      

    }


};

const aboutus = async(req, res) => {
    try {
    
      const aboutData = await homeappModel.getaboutData();

        var data = {
       "status": "1",
        "message": "About us",
        "data":aboutData,
        
        };
    res.status(200).json(data);
    } catch (error) {
     

     
        console.error(error);
        res.status(500).json({ message: 'data not found' });
      

    }


};
  
const terms = async(req, res) => {
    try {
    
      const aboutData = await homeappModel.gettermsData();

        var data = {
       "status": "1",
        "message": "Terms & Condition",
        "data":aboutData,
        
        };
    res.status(200).json(data);
    } catch (error) {
     

     
        console.error(error);
        res.status(500).json({ message: 'data not found' });
      

    }


};

const subcatee = async(req, res) => {
    try {
      const appDetatils = req.body; 
      const categoryList = await homeappModel.getsubcategoryList(appDetatils);

        var data = {
       "status": "1",
        "message": "data found",
        "data":categoryList,
        
        };
    res.status(200).json(data);
    } catch (error) {
       if (error.message === 'Products not found') {

        var data = {
           "message": "Products not found",
           "data":[],
           
           };
           res.status(400).json(data);
        //res.status(400).json({ message: 'Products not found' });
      }
      
      
      else {
        console.error(error);
        res.status(500).json({ message: 'Internal Server Error' });
      }

    }


};
  
const appinfo = async(req, res) => {

    try {
      const appDetatils = req.body; 
      const baseurl =  process.env.BUNNY_NET_IMAGE;
    
      const appdata = await productlistModel.appinformation(appDetatils);
      const trailpackimage = await productlistModel.trailpackimagedata(appDetatils);
      const imgurl =  process.env.base_url;
       const bgimage = await knex('app_settings')
                      .where('store_id', 7)
                      .select('bg_image_color', knex.raw(`CONCAT('${imgurl}', home_bg_image) as home_bg_image`))
                      .first();

        var data = {
        "status": "1",
        "message": "data found",
        "data":appdata,
        "oneapi_bg_first_image": bgimage,
        "trailpackimage":trailpackimage
         //"data":appdata
        
        };
    res.status(200).json(data);
    } catch (error) {
      console.error(error);
      res.status(500).json({ status: 0, message: error.message  });
    }

};

const updateproductdetails = async(req, res) => {
  try {
    const appDetatils = req.body;   
    const appdata = await productlistModel.UpdateproductDetails(appDetatils);
      var data = {
      "status": "1",
      "message": "data found",
      "data":appdata
      };
  res.status(200).json(data);
  } catch (error) {
    console.error(error);
    // res.status(500).json({ status: 0, message: 'Internal Server Error' });
     res.status(500).json({ status: 0, message: error.message  });
  }
};

module.exports = {
    oneapi,
    catee,
    product_det,
    subcatee,
    cat_product,
    brand_list,
    aboutus,
    terms,
    appinfo,
    updateproductdetails,
    featurecat_prod
  };
  