const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const axios = require('axios');
const apiKey = 'AIzaSyADPEHze6hgRTG83JXfEJ6owhtNTmJJWwg'; // Replace with your Geolocation API key

const city = async () => {
   
    return citylist = await knex('city')
         .join('society','city.city_id','=','society.city_id')
         .where('city.status',1)
         .select('city.city_id','city.city_name')
         .groupBy('city.city_id','city.city_name')
 
};

const society = async (appDetatils) => {
    city_id = appDetatils.city_id
    return societylist =  await knex('society')
    .join('city', 'society.city_id','=','city.city_id')
    .join('store_society','store_society.society_id','=','society.society_id')
    .where('city.city_id',city_id)
 
};

const showAddress = async (appDetatils) => {
    // Step 1: Retrieve the city lists (English and Arabic)
    const user_id = appDetatils.user_id;

    // Fetch the English city names
    const cityNamesResult = await knex('city')
        .where('status', 1)
        .select(knex.raw('GROUP_CONCAT(city_name) as cityName'));
    const cityNameList = cityNamesResult[0].cityName.split(',');

    // Fetch the Arabic city names
    const cityNamesAResult = await knex('city')
        .where('status', 1)
        .select(knex.raw('GROUP_CONCAT(CONVERT(arabic_name USING utf8mb4)) as cityName'));
    const cityNameListA = cityNamesAResult[0].cityName.split(',');
      const baseurl = process.env.BUNNY_NET_IMAGE;

    // Step 2: Retrieve the address list
    const addresses = await knex('address')
        .select(
            'address.address_id',
            'address.type',
            'address.user_id',
            'address.receiver_name',
            'address.receiver_phone',
            'address.receiver_email',
            'address.house_no',
            'address.landmark',
            'address.lat',
            'address.lng',
            'address.country_code',
            'address.society as society_name',
            knex.raw(`CONCAT('${baseurl}', address.doorimage) as doorimage`),
            knex.raw("CONCAT(address.lat, ',', address.lng) as latlng"),
            'address.dial_code'
        )
        .where('user_id', user_id)
        .where('select_status', '!=', 2);

    // Function to fetch address details using Google Maps API
    const getFormattedAddress = async (lat, lng) => {
        const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lng}&key=${apiKey}`;
        try {
            const response = await axios.get(url);
            const data = response.data;
            if (data.results.length > 0) {
                return data.results[0].formatted_address;
            }
            return null;
        } catch (error) {
            console.error('Error fetching the geolocation:', error);
            return null;
        }
    };

    // Step 3: Check if the address's city name exists in the city lists and validate using Geocoding API
    const updatedAddresses = await Promise.all(
        addresses.map(async (address) => {
            let cityExists =
                cityNameList.includes(address.city) || cityNameListA.includes(address.city);

            if (!cityExists) {
                const formattedAddress = await getFormattedAddress(address.lat, address.lng);
                if (formattedAddress) {
                    // Dynamically check if the formatted address contains any city from the dynamic city lists
                    cityExists = cityNameList.concat(cityNameListA).some(city =>
                        formattedAddress.includes(city)
                    );
                }
            }

            return {
                ...address,
                cityExists // true or false based on both checks
            };
        })
    );

    return updatedAddresses;
};

const removeAddress = async (appDetatils) => {

    //user_id = appDetatils.user_id

    address_id = appDetatils.address_id;
    checkcart = await knex('orders')
               .where('address_id', address_id);

    if(checkcart.length==0) {
        deladdress= await knex('address')
         .where('address_id',address_id)
         .delete();
        
    }  
    else{
        deladdress= await knex('address')
            .where('address_id',address_id)
            .update({'select_status': 2});
    }


};

const doorimage = async (imageData) => {
    appDetatils = imageData;
    address_id =imageData.address_id;
    user_id=imageData.user_id;
    filename = imageData.path;
        
        if(filename){
            
                 insertaddress = await knex('address')
                .where('address_id', address_id)
                .update({
                    doorimage:filename
                });
            
        }

     
};

const editAddress = async (imageData) => {
    appDetatils = imageData;
    address_id =imageData.address_id;
    user_id=imageData.user_id;
    type = imageData.type;
    receiver_name = imageData.receiver_name;
    receiver_phone = imageData.receiver_phone;
    receiver_phone_code =  imageData.receiver_phone_code;
    receiver_email = imageData.receiver_email;
   // city_name = appDetatils.city_name;
    society_name = imageData.society_name;
    house_no =imageData.house_no;
    landmark =imageData.landmark;
    //state = appDetatils.state;
   // pin = appDetatils.pin;
    lat = imageData.lat;
    lng = imageData.lng;
    latlng = lat +","+ lng;
    dial_code = imageData.dial_code;
    filename = imageData.path;


    
   // emirates = appDetatils.emirates;
  //  building_villa = appDetatils.building_villa;
  //  street = appDetatils.street;
   // country_code = appDetatils.country_code;
   // prefix_code = appDetatils.prefix_code;
    const status= 1;
    unselect= await knex('address')
                     .where('user_id' ,user_id)
              
 

    //  if(unselect){
    //     unselect=  await knex('address')
    //              .where('user_id' ,user_id)
    //              .update({'select_status': 0});
    //     }
     

        // citydet = await knex('city')
        // .where('city_name',city_name)
        // .first();
        // city_id = citydet.city_id;


        if(society_name != ''){
            socitydet =  await knex('society')
                    .where('society_name',society_name)
                    .first();
            if(socitydet){
                society_id = socitydet.society_id;
            }else{
                society_id = '';
            }
        }else{
           
            society_id = '';
        }

        const added_at=  new Date();

        insertaddress = await knex('address')
        .where('address_id', address_id)
        .update({
        'receiver_name':receiver_name,
        'receiver_phone':receiver_phone,
        'receiver_email':receiver_email,
        //'city':city_name,
        'society':society_name,
        //'city_id':city_id,
        'society_id':society_id,
        'house_no':house_no,
        'landmark': landmark,
        //'state':state,
        //'pincode':pin,
        'select_status':1,
        'lat' : lat,
        'lng' : lng,
        'type': type,
        'added_at':added_at,
        //'emirates':emirates,
        'building_villa':'',
        'street':'',
        //'prefix_code':prefix_code,
        'country_code':receiver_phone_code,
        'latlng': latlng,
        'dial_code':dial_code
        });
        
        if(filename){
            
                 insertaddress = await knex('address')
                .where('address_id', address_id)
                .update({
                    doorimage:filename
                });
            
        }

     
};

const addAddress = async (imageData) => {
    appDetatils = imageData;
    //user_id = appDetatils.user_id
    user_id=imageData.user_id;
    type = imageData.type;
    receiver_name = imageData.receiver_name;
    receiver_phone = imageData.receiver_phone;
    receiver_phone_code =  imageData.receiver_phone_code;
    receiver_email = imageData.receiver_email;
   // city_name = appDetatils.city_name;
    society_name = imageData.society_name;
    house_no =imageData.house_no;
    landmark =imageData.landmark;
    //state = appDetatils.state;
   // pin = appDetatils.pin;
    lat = imageData.lat;
    lng = imageData.lng;
    latlng = lat +","+ lng;
    dial_code = imageData.dial_code;
    filename = imageData.path;
   // emirates = appDetatils.emirates;
  //  building_villa = appDetatils.building_villa;
  //  street = appDetatils.street;
   // country_code = appDetatils.country_code;
   // prefix_code = appDetatils.prefix_code;
    const status= 1;
   
    unselect= await knex('address')
                     .where('user_id' ,user_id)
                     
            // if(unselect){
            // unselect=  await knex('address')
            //          .where('user_id' ,user_id)
            //          .update({'select_status': 0});
            // }
         
            // citydet = await knex('city')
            //           .where('city_name',city_name)
            //           .first();
            // city_id = citydet.city_id;
            
            
            
            if(society_name != ''){
                
                socitydet =  await knex('society')
                        .where('society_name',society_name)
                        .first();
                if(socitydet){
                    society_id = socitydet.society_id;
                }else{
                    society_id = '';
                }
            }else{
               
                society_id = '';
            }
            
           // return society_id;
          
            insertaddress = [];
       
            const added_at=  new Date();
    	    if(type == "Others" || type =="Work"){
              //  return 5678;
                insertaddress =  await knex('address')
                .insert({
                user_id:user_id,
                receiver_name:receiver_name,
                receiver_phone:receiver_phone,
                receiver_email:receiver_email,
                //city:city_name,
                society:society_name,
                //city_id:city_id,
                society_id:society_id,
                house_no:house_no,
                landmark:landmark,
                //state:state,
                //pincode:pin,
                select_status:1,
                lat : lat,
                lng : lng,
                type:type,
                added_at:added_at,
                //emirates:emirates,
                //building_villa:building_villa,
                //street:street,
                //prefix_code:prefix_code,
                country_code:receiver_phone_code,
                latlng: latlng,
                dial_code:dial_code,
                doorimage:filename
                }) ;
    	   
    	    }
    	    else{
    	        getaddress= await knex('address')
                     .where('user_id' ,user_id)
                     .where('type', type)
                     .first();
    	        if(getaddress){
                        insertaddress = await knex('address')
                        .where('user_id' ,user_id)
                        .where('type', type)
                        .update({
                        'receiver_name':receiver_name,
                        'receiver_phone':receiver_phone,
                        'receiver_email':receiver_email,
                        //'city':city_name,
                        'society':society_name,
                        //'city_id':city_id,
                        'society_id':society_id,
                        'house_no':house_no,
                        'landmark': landmark,
                        //'state':state,
                        //'pincode':pin,
                        'select_status':1,
                        'lat' : lat,
                        'lng' : lng,
                        'type': type,
                        'added_at':added_at,
                        //'emirates':emirates,
                        //'building_villa':building_villa,
                        //'street':street,
                        //'prefix_code':prefix_code,
                        'country_code':receiver_phone_code,
                        'latlng': latlng,
                        'dial_code':dial_code,
                         'doorimage':filename
                        });
    	        }else
                {
                insertaddress =  await knex('address')
                .insert({
                user_id:user_id,
                receiver_name:receiver_name,
                receiver_phone:receiver_phone,
                receiver_email:receiver_email,
                //city:city_name,
                society:society_name,
                //city_id:city_id,
                society_id:society_id,
                house_no:house_no,
                landmark:landmark,
                //state:state,
                //pincode:pin,
                select_status:1,
                lat : lat,
                lng : lng,
                type: type,
                added_at:added_at,
                //emirates:emirates,
                //building_villa:building_villa,
                //street:street,
                //prefix_code:prefix_code,
                country_code:receiver_phone_code,
                latlng: latlng,
                dial_code:dial_code,
                 doorimage:filename
                }) ;
    	        }
    	    }
        return insertaddress
};


const checkaddresshome = async (imageData) => {
appDetatils = imageData;
address_id =appDetatils.address_id;
user_id=appDetatils.user_id;

return await knex('address')
  .where({
    user_id: user_id,
    type: 'Home'
  })
  .where('address_id', '!=',address_id);
  
};

module.exports = {
addAddress,
editAddress,
showAddress,
removeAddress,
city,
society,
doorimage,
checkaddresshome
};