const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const crypto = require('crypto'); 


const SaveCardDetails = async (appDetails) => {
const {user_id}=appDetails;
// Generate random letters
const chars1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
let val1 = "";
for (let i = 0; i < 6; i++) {
val1 += chars1.charAt(Math.floor(Math.random() * chars1.length));
}

// Generate random digits
const chars3 = "0123456789";
let val3 = "";
for (let i = 0; i < 2; i++) {
val3 += chars3.charAt(Math.floor(Math.random() * chars3.length));
}

// Generate a random substring from md5 hash of current time
const cr1 = crypto.createHash('md5').update(String(Date.now())).digest('hex').substr(Math.floor(Math.random() * 25), 2);
const pay_amounts=1;
// Combine all parts to form cart_id
const randomNumber = val1 + val3 + cr1;
const number = randomNumber;
const description = 'Order description';
const amount = (pay_amounts).toFixed(2); // Ensure two decimal places
const currency = 'AED';

// TotalPay Credentials for Test
// const merchantKey = '968abd2e-79ce-11ef-8430-ee2650fd5759';
// const merchantpassword = 'abdf10a546b5197cdf81508a3d3c9e23';
   
// TotalPay Credentials for Live
const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
const merchantpassword = '96bb03851c3553fd132339acc06ce060';

const hashData = `${number}${amount}${currency}${description}${merchantpassword}`;
const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');

const userdetails = await knex('users')
.where('id', user_id)
.select('name', 'email')
.first();

// Customer Information
const customerInfo = { name: userdetails.name, email: userdetails.email,birth_date:'1970-02-17' }; // Only include email as per comments

const address = await knex('address')
.where('address.user_id', user_id)
.select('address.receiver_phone', 'address.house_no', 'address.state')
.first();

// Billing Information
const billingAddress = {
country: 'AE',
state: 'Dubai',
city: 'Dubai',
address: 'dubai',
house_number:305,
phone: "123456789",
district:'Dubai'
};

//return billingAddress;
const ordertype = 'savecard';

const orderJson = { number, description, amount, currency };
const custom_data = {ordertype,user_id}

const mainJson = {
merchant_key: merchantKey,
operation: 'purchase',
methods: ['card'],
success_url: 'https://quickart3.quickart.ae/nodejsapp/api/savesuccess',
cancel_url: 'https://quickart3.quickart.ae/nodejsapp/api/savefailure',
hash,
order: orderJson,
customer: customerInfo,
billing_address: billingAddress,
custom_data:custom_data,
// req_token:true,
recurring_init:true
};

const jsonData = JSON.stringify(mainJson);
// return jsonData;

const checkoutUrl = 'https://checkout.totalpay.global/api/v1/session';

try {
const fetch = (await import('node-fetch')).default;

const response = await fetch(checkoutUrl, {
method: 'POST',
headers: { 'Content-Type': 'application/json' },
body: jsonData,
});

if (!response.ok) {
throw new Error(`HTTP error! Status: ${response.status}`);
}

return await response.json();
} catch (error) {
console.error('Error sending payment data:', error);
throw error; // Re-throw for handling in the calling code
}
};

const InsertCard = async (appDetails) => {
const group_id = appDetails.order_id;
const notifybys = await knex('payment_notification_details')
.where('group_id',group_id)
.orderBy('id','DESC')
.first();  

const dataString = notifybys.json_data;
const data = JSON.parse(dataString);

//Save card details after success
const insertCardDetails =  await knex('tbl_user_bank_details')
.insert({
user_id:data.custom_data.user_id,
si_sub_ref_no:data.recurring_token,
recurring_init_trans_id:data.recurring_init_trans_id,
hash:data.hash,
holder_name:data.customer_name,
email_id:data.customer_email,
card_no:data.card,
card_expired_date:data.card_expiration_date,
bank_type:"totalpay",
});

    // TotalPay Credentials for Test
    const payment_id=data.id;
    // const merchantKey = '968abd2e-79ce-11ef-8430-ee2650fd5759';
    // const merchantpassword = 'abdf10a546b5197cdf81508a3d3c9e23';
    
    // TotalPay Credentials for Live
    const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
    const merchantpassword = '96bb03851c3553fd132339acc06ce060';

const hashData = `${payment_id}${merchantpassword}`;
const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');
const mainJson = {
merchant_key: merchantKey,
payment_id:payment_id,
hash,
};

const jsonData = JSON.stringify(mainJson);
const checkoutUrl = 'https://checkout.totalpay.global/api/v1/payment/void';

try {
const fetch = (await import('node-fetch')).default;

const response = await fetch(checkoutUrl, {
method: 'POST',
headers: { 'Content-Type': 'application/json' },
body: jsonData,
});

if (!response.ok) {
throw new Error(`HTTP error! Status: ${response.status}`);
}

return data;
} catch (error) {
console.error('Error sending payment data:', error);
throw error; // Re-throw for handling in the calling code
}

};  

const DeductionRecurringPayment= async (appDetails) =>{
// TotalPay Credentials for Test/Live
const recurring_init_trans_id="3bb7dbc8-5e0f-11ef-9ae0-0e182cc57e01";
// TotalPay Credentials for Test
// const merchantKey = '7f066cba-36b4-11ee-86cb-eecb8191d36e';
// const merchantpassword = '96bb03851c3553fd132339acc06ce060';

// TotalPay Credentials for Live
const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
const merchantpassword = '96bb03851c3553fd132339acc06ce060';

const recurring_token="3bc316f0-5e0f-11ef-a2dd-0e182cc57e01";
const pay_amounts=1;
const orderNumber="order-1234";
const orderDescription="Payment Deduction";
const amount = (pay_amounts).toFixed(2); // Ensure two decimal places

const hashData = `${recurring_init_trans_id}${recurring_token}${orderNumber}${amount}${orderDescription}${merchantpassword}`;
const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');
const mainJson = {
merchant_key: merchantKey,
recurring_init_trans_id:recurring_init_trans_id,
recurring_token:recurring_token,
hash,
order:{
number:orderNumber,
amount:amount,
description:orderDescription
}
};

const jsonData = JSON.stringify(mainJson);
const checkoutUrl = 'https://checkout.totalpay.global/api/v1/payment/recurring';

try {
const fetch = (await import('node-fetch')).default;

const response = await fetch(checkoutUrl, {
method: 'POST',
headers: { 'Content-Type': 'application/json' },
body: jsonData,
});
if (!response.ok) {
throw new Error(`HTTP error! Status: ${response.status}`);
}

return await response.json();
} catch (error) {
console.error('Error sending payment data:', error);
throw error; // Re-throw for handling in the calling code
}

};

const DeleteCardDetails = async (appDetails) => {
const {user_id,bank_id}=appDetails;
const bankDetails = await knex('tbl_user_bank_details')
.where('id', bank_id)
.select('si_sub_ref_no')
.first();

// Step 1: Check if there are any pending orders or related orders using the bank_id
const relatedOrders = await knex('orders')
.join('subscription_order','subscription_order.cart_id','orders.cart_id')
.where('orders.user_id', user_id)
.where('orders.si_sub_ref_no', bankDetails.si_sub_ref_no)
.where('subscription_order.order_status','Pending') // Assuming these statuses mean the order is still active
.where('orders.payment_type','payperdelivery')
.where('subscription_order.si_payment_flag','no')
.count('subscription_order.id as count')
.first();

// Step 2: If there are pending orders, throw an error
if (relatedOrders.count > 0) {
throw new Error('Card cannot be deleted as it is associated with pending orders');
}
await knex('tbl_user_bank_details')
.where('user_id', user_id)
.where('id', bank_id)
.update({ 'is_delete': 1 });
};

module.exports = {
SaveCardDetails,
InsertCard,
DeductionRecurringPayment,
DeleteCardDetails,
};