const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const { format } = require('date-fns');
const moment = require('moment');
const crypto = require('crypto');
const fetch = (...args) => import('node-fetch').then(({ default: fetch }) => fetch(...args));
require('moment-timezone');
const uaeTime = moment.tz(new Date(), "Asia/Dubai");
const axios = require('axios');
require('dotenv').config();
const { codorderplacedMail } = require('../sendGridService');


const getQuickordercheckout = async (appDetails) => {
    const current = new Date();

    // Destructure other details from appDetails
    const {
        user_id:userId,
        address_id: addressId,
        delivery_date: deliveryDate,
        time_slot: timeSlot,
        store_id: storeId,
        del_partner_tip: delPartnerTip,
        del_partner_instruction: delPartnerInstruction,
        order_instruction:order_instruction,
        payment_method: paymentMethod,
        payment_status: paymentStatus,
        wallet,
        totalwalletamt: totalWalletAmt,
        coupon_id: couponId,
        coupon_code: couponCode,
        payment_id: paymentId,
        payment_gateway: paymentGateway,
        si_sub_ref_no: siSubRefNo,
        bank_id: bankId,
        payment_type:paymentType,
        order_id:paymentOrderId
    } = appDetails;





    // Determine siStatus based on siSubRefNo
    const siStatus = siSubRefNo ? "yes" : "no";
    const hash = crypto.createHash('md5').update(String(Date.now())).digest('hex');
    const hashSubstring = hash.substring(0, 2); // Adjust substring length as needed
    // Combine all parts to form group_id
    const groupId = (paymentOrderId)? paymentOrderId : generateRandomLetters(6) + generateRandomDigits(2) + hashSubstring;
    // Query address from the database
    const ar = await knex('address')
    .select('society', 'city', 'city_id', 'society_id', 'lat', 'lng', 'address_id','house_no','receiver_email','landmark')
    .where('user_id',userId) // Check if this is the correct condition for your use case
    .where('address_id', addressId)
    .first(); 

    if (!ar) {
    throw new Error('No address found for the provided user ID and address ID');
    }

   
    // Get today's date and current time in Dubai timezone
    const dubaiTime = moment.tz("Asia/Dubai");
    const todayDubai = dubaiTime.format("YYYY-MM-DD");
    const isAfter6PM = dubaiTime.hour() > 17;
    const isAfter12PM = dubaiTime.hour() > 11;

    // Condition 1: Check if any order has a sub_delivery_date of today
    if (deliveryDate === todayDubai && isAfter12PM) {
    throw new Error("Unable to place order for selected date time. Please select different date and time.");
    }


    // Condition 2: If it's after 6 PM in Dubai, prevent placing orders for tomorrow with "06:00 am - 10:00 am" time slot
    if (isAfter6PM) {
    const tomorrowDubai = dubaiTime.add(1, 'day').format("YYYY-MM-DD"); // Get tomorrow's date in Dubai time
    if (deliveryDate == tomorrowDubai && timeSlot == "06:00 am - 10:00 am") {
    throw new Error(`Unable to place order for selected date time. Please select different date and time.`);
    }
    }

    // Condition 3: Check if any order has a sub_delivery_date of today
    if (deliveryDate === todayDubai && (timeSlot == "06:00 am - 10:00 am" || timeSlot == "02:00 pm - 05:00 pm")) {
    throw new Error("Unable to place order for selected date time. Please select different date and time.");
    }

    //stock 0 Or not check 
    const storeItemList = await knex('store_orders')
    .select('store_products.stock')
    .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
    .where('store_orders.store_approval', userId)
    .where('store_orders.order_cart_id', 'incart')
    .whereNull('subscription_flag');
    // Iterate through the list of items and check the stock
    for (const storeItem of storeItemList) {
    if (storeItem.stock === 0) {
    throw new Error("One or more items in your cart are out of stock. Unable to proceed with the order.");
    }
    }


     // Fetch user phone and wallet
     const user = await knex('users')
     .select('user_phone', 'wallet','country_code','name','email')
     .where('id', userId)
     .first();
     let actualWallet=user.wallet;
     let WalletBalanace=user.wallet-totalWalletAmt;
     let userPhone=user.country_code+user.user_phone;
     let userName=user.name;
     let userEmail=(user.email)?user.email:ar.receiver_email;

    if (!user) {
    throw new Error('User not found');
    }
    //store order details
    const storeDetailsAmt = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    .join('product','product_varient.product_id','=','product.product_id')
    .where('store_orders.store_approval',userId)
    .where('store_orders.order_cart_id', 'incart')
    .whereNull('subscription_flag')
    .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
    .first(); 

    // Fetch delivery charges
    const deliveryFlag = await knex('app_settings')
    .where('store_id', storeId)
    .select('cod_charges')
    .first();

    const codCharges = (paymentMethod.toLowerCase() === 'cod') ? deliveryFlag.cod_charges : 0;

    let couponPriceAmount=0;
    if(couponCode){
    const CouponDiscount = await knex('store_orders')
    .sum({ total_price: 'price' })
    .where('price', '=', knex.ref('total_mrp'))
    .where('order_cart_id', 'incart')
    .where('store_approval', userId)
    .where('subscription_flag',null)
    .first();

    const CouponDetails = await knex('coupon')
    .where('coupon_code', couponCode)
    .first();
    couponPriceAmount=(parseFloat(CouponDiscount.total_price)*parseFloat(CouponDetails.amount))/100;
    }
    const TotalpriceAmount=((parseFloat(storeDetailsAmt.Totalprice)+parseFloat(delPartnerTip)+parseFloat(codCharges))-(parseFloat(couponPriceAmount)+parseFloat(totalWalletAmt)));
    const WithWalletAmount=parseFloat(TotalpriceAmount)+parseFloat(totalWalletAmt);     
    const WalletDiscountAmount=((((parseFloat(storeDetailsAmt.Totalprice)+parseFloat(delPartnerTip)+parseFloat(codCharges))-couponPriceAmount)*50)/100).toFixed(2);
    const WalletStatus = (wallet.toLowerCase() === 'yes' && actualWallet >= WalletDiscountAmount) ? 'percentage' : 'fixed';

    if(siStatus == 'yes' && paymentMethod != 'COD')
        {
      
        const BankDetails = await knex('tbl_user_bank_details')
        .where('si_sub_ref_no', siSubRefNo)
        .where('user_id', userId)
        .first();
    
        if (BankDetails) {
        // Success: BankDetails found   
        // TotalPay Credentials for Test/Live
        const recurring_init_trans_id=BankDetails.recurring_init_trans_id;
        // TotalPay Credentials for Test
        // const merchantKey = '968abd2e-79ce-11ef-8430-ee2650fd5759';
        // const merchantpassword = 'abdf10a546b5197cdf81508a3d3c9e23';
        // TotalPay Credentials for Live
        const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
        const merchantpassword = '96bb03851c3553fd132339acc06ce060';
        const recurring_token=BankDetails.si_sub_ref_no;
        const pay_amounts=TotalpriceAmount;
        const orderNumber=groupId;
        const orderDescription="Payment Deduction";
        const amount = (pay_amounts).toFixed(2); // Ensure two decimal places
    
        const hashData = `${recurring_init_trans_id}${recurring_token}${orderNumber}${amount}${orderDescription}${merchantpassword}`;
        const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');
        const mainJson = {
        merchant_key: merchantKey,
        recurring_init_trans_id:recurring_init_trans_id,
        recurring_token:recurring_token,
        hash,
        order:{
        number:groupId,
        amount:amount,
        description:orderDescription
        }
        };
    
        const jsonData = JSON.stringify(mainJson);
        const checkoutUrl = 'https://checkout.totalpay.global/api/v1/payment/recurring';
    
        try {
        const fetch = (await import('node-fetch')).default;
    
        const response = await fetch(checkoutUrl, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: jsonData,
        });
        
        const data = await response.json();
        const status = data.status.toLowerCase();
        if (status === 'decline' || status === 'pending') {
        const errorMessage = status === 'decline' 
        ? 'Card issue detected! Status: decline' 
        : `HTTP error! Status: ${data.status}`;
        throw new Error(errorMessage);
        }

        if (!response.ok) {
        throw new Error(`HTTP error! Status: ${response.status}`);
        }
        
        await knex('tbl_si_deduction_log').insert({
        si_sub_ref_no:siSubRefNo,
        user_id: userId,
        amount: parseFloat(TotalpriceAmount).toFixed(2),
        payment_method: 'SI',
        payment_status:0,
        card_id:groupId,
        });
        //return await response.json();
        } catch (error) {
        console.error('Error sending payment data:', error);
        throw error; // Re-throw for handling in the calling code
        }
    
    
        } else {
        // No BankDetails found
        throw new Error('No bank details found for the given criteria.');
        }
    }

    // Fetch orders
    const data_array = await knex('store_orders')
        .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .select('store_orders.*')
        .where('store_orders.store_approval', userId)
        .whereNull('subscription_flag')
        .where('store_orders.order_cart_id', "incart");

        let price2 = 0;
        let tax_p = 0;
        let tax_price = 0;
        let TotalpriceStore=storeDetailsAmt.Totalprice;
        for (const productList of data_array) {
            const { varient_id: varientId, qty: orderQty,store_order_id:storeOrderId } = productList;

            // Generate cart_id
            const hash = crypto.createHash('md5').update(String(Date.now())).digest('hex');
            const cartId = generateRandomLetters(4) + generateRandomDigits(2) + hash.substring(0, 2);

            const product = await knex('store_orders')
                .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
                .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
                .join('product', 'product_varient.product_id', '=', 'product.product_id')
                .select('store_orders.*', 'product.cat_id', 'product_varient.buying_price', 'store_products.mrp')
                .where('store_orders.order_cart_id', 'incart')
                .where('store_orders.varient_id', varientId)
                .where('store_orders.store_id', storeId)
                .where('store_orders.store_approval', userId)
                .whereNull('subscription_flag')
                .first();
    
            if (!product) {
                throw new Error('Product not found');
            }
    
            const { price, mrp, tx_per: taxPer, tx_price: taxPrice, min_ord_qty: minOrderQty, max_ord_qty: maxOrderQty, stock, product_name: productName, quantity, unit, varient_image: varientImage } = product;
            const totalMrp = mrp; // Adjust this if needed
            price2=price;
        
            const codorderamt = codCharges ? (price2 * codCharges / TotalpriceStore) : 0;
            const delPartnerTipAmt = delPartnerTip ? (price2 * delPartnerTip / TotalpriceStore) : 0;
            let couponPriceProduct=0;
            const CouponDiscounts = await knex('store_orders')
            .sum({ total_price: 'price' })
            .where('price', '=', knex.ref('total_mrp'))
            .where('order_cart_id', 'incart')
            .where('store_orders.varient_id', varientId)
            .where('store_approval', userId)
            .whereNull('subscription_flag')
            .first();

            if(couponCode && (CouponDiscounts.total_price > 0)){
            const CouponDiscount = await knex('store_orders')
            .sum({ total_price: 'price' })
            .where('price', '=', knex.ref('total_mrp'))
            .where('order_cart_id', 'incart')
            .where('store_approval', userId)
            .where('subscription_flag',null)
            .first();

            const CouponDetails = await knex('coupon')
            .where('coupon_code', couponCode)
            .first();
            couponPriceProduct=(parseFloat(price2)*parseFloat(CouponDetails.amount))/100;
            }
            const totalPrice = (parseFloat(price2)+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt))-parseFloat(couponPriceProduct);
            
            let paidByWallet=0;
        
            if(wallet.toLowerCase() === 'yes'){
             if(WalletStatus == 'percentage'){
                paidByWallet=(parseFloat(totalPrice)*50)/100;
             }else
             {
                paidByWallet=(parseFloat(totalPrice)*parseFloat(totalWalletAmt))/parseFloat(WithWalletAmount);  
             }
            }
            
            const paymentStatus = (paymentMethod.toLowerCase() === 'cod') ? 'Pending' : 'success';
            const remPrice=(paymentMethod.toLowerCase() === 'cod') ? (totalPrice-paidByWallet) : 0;
           
            const timeslotval=(productList.sub_time_slot) ? productList.sub_time_slot : timeSlot;
            var deliverydateval=(productList.sub_delivery_date) ? productList.sub_delivery_date : deliveryDate;
           

          const orderID =await knex('orders')
            .insert({
            cart_id: cartId,
            total_price: totalPrice.toFixed(2),
            price_without_delivery: totalPrice.toFixed(2),
            total_products_mrp: totalPrice.toFixed(2),
            delivery_charge:0,
            user_id: userId,
            store_id: storeId,
            rem_price:(remPrice)? parseFloat(remPrice).toFixed(2):0,
            order_date: current,
            delivery_date: deliverydateval,
            time_slot: timeslotval,
            address_id: addressId,
            avg_tax_per: 0,
            total_tax_price: 0,
            total_delivery: 1, // Adjust if needed
            del_partner_tip: (delPartnerTipAmt) ? parseFloat(delPartnerTipAmt).toFixed(2):0,
            del_partner_instruction: delPartnerInstruction,
            order_instruction:order_instruction,
            group_id: groupId, // Use groupId for group_id or adjust as needed
            is_subscription: null,
            cod_charges: (codorderamt)? parseFloat(codorderamt).toFixed(2):0,
            paid_by_wallet:(paidByWallet)? parseFloat(paidByWallet).toFixed(2): 0,
            payment_method:paymentMethod,
            si_sub_ref_no:siSubRefNo,
            coupon_id:(couponId) ? couponId : 0,
            coupon_code:couponCode,
            coupon_discount:(couponPriceProduct) ? parseFloat(couponPriceProduct).toFixed(2):0,
            payment_status:paymentStatus,
            payment_type:paymentType,
            pastorecentrder:'new'
            }).returning('order_id');
      
            await knex('store_orders')
            .where('store_order_id',storeOrderId)
            .update({
            'order_cart_id':cartId,
            }); 

            const getSub =await knex('subscription_order')
            .select('id')
            .orderBy('id','DESC')
            .first();
            let subscription_id=(getSub)?getSub.id:0;
            subscription_id=subscription_id+1;

        const subscriptionID = await knex('subscription_order')
            .insert({
            'store_order_id':storeOrderId,
            'cart_id':cartId,
            'user_id':userId,
            'order_id':orderID,
            'store_id':storeId,
            'delivery_date':deliverydateval,
            'time_slot':timeslotval,
            'created_date': current,
            'order_status':'Pending',
            'si_payment_flag':(paymentMethod.toLowerCase() === 'cod') ? "no" : "yes",
            'group_id':groupId,
            'subscription_id':subscription_id
            });     
            
            //Paid by Wallet Save
            if(paidByWallet > 0 ){
            await knex('wallet_history').insert({
            user_id: userId,
            amount: paidByWallet.toFixed(2),
            resource: 'order_placed_wallet',
            type:'deduction',
            group_id:groupId,
            cart_id:cartId
            })
            }   
        
        }

        //Wallet amount update for and insert wallet  
         await knex('users')
        .where('id',userId)
        .update({'wallet':WalletBalanace});

        //SMS Code
        message = "Thank you for your order! Your order "+groupId+" is now being processed & will be delivered right on schedule.  "
        sendSMSOrder(userPhone,message);
        
        //Email Code 
        totalCal = await knex('orders')
        .where('group_id', groupId)
        .sum('coupon_discount as coupon_discount')
        .sum('rem_price as rem_price')
        .sum('paid_by_wallet as paid_by_wallet')
        .sum('cod_charges as cod_charges')
        .sum('total_products_mrp as total_products_mrp');
        

        storeOrders = await knex('store_orders')
        .select('store_orders.*','orders.group_id','orders.time_slot','orders.total_delivery')
        .join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
        .where('orders.group_id', groupId);

        finalAmount = parseFloat(totalCal[0].total_products_mrp).toFixed(2);
        const logo = await knex('tbl_web_setting').first();
        const appName = logo ? logo.name : null;
        // Fetching the first record from the 'currency' table
        const currency = await knex('currency').first();
        const currencySign = currency ? currency.currency_sign : null;
        
        // Get the year, month, and day in the required format
        const year = current.getFullYear();
        const month = String(current.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
        const day = String(current.getDate()).padStart(2, '0');
        // Combine into the desired format
        const formattedDate = `${year}-${month}-${day}`;

        const templateData = {
        baseurl: process.env.base_url,
        group_id: groupId,
        user_name: userName,
        user_email: userEmail,
        paymentMethod: paymentMethod,
        delivery_date:deliverydateval,
        orderss_address:ar.house_no+', '+ar.landmark+', '+ar.society,
        store_orderss:storeOrders,
        coupon_discount:totalCal[0].coupon_discount.toFixed(2),
        paid_by_wallet:totalCal[0].paid_by_wallet.toFixed(2),
        cod_charges:totalCal[0].cod_charges.toFixed(2),
        final_amount:finalAmount,
        app_name:appName,
        currency_sign:currencySign,
        order_type:"quick",
        order_date:formattedDate,
        };
        const subject = 'Order Successfully Placed'
        // Trigger the email after order is placed
        sendMail = await codorderplacedMail(userEmail,templateData,subject,groupId);

        return "success";
};


const getSubordercheckout  = async (appDetails) => {
    const current = new Date();

    // Destructure other details from appDetails
    let {
    user_id:userId,
    address_id: addressId,
    delivery_date: deliveryDate,
    time_slot: timeSlot,
    store_id: storeId,
    del_partner_tip: delPartnerTip,
    del_partner_instruction: delPartnerInstruction,
    order_instruction:order_instruction,
    payment_method: paymentMethod,
    payment_status: paymentStatus,
    wallet,
    totalwalletamt: totalWalletAmt,
    coupon_id: couponId,
    coupon_code: couponCode,
    payment_id: paymentId,
    payment_gateway: paymentGateway,
    si_sub_ref_no: siSubRefNo,
    bank_id: bankId,
    is_subscription:isSubscription,
    payment_type:paymentType,
    //AutoRenewSubCart:AutoRenewSubCart,
    order_id:paymentOrderId
    } = appDetails;
    const del_partner_tip=0;

    if (wallet.toLowerCase() === 'yes' && (totalWalletAmt === undefined || totalWalletAmt == 0  || totalWalletAmt == '' )) {
        const user = await knex('users')
        .select('user_phone', 'wallet')
        .where('id', userId)
        .first();
        
        // Calculate reserve amount
        const reserveAmt = await knex('orders')
        .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
        .select('orders.reserve_amount')
        .where('orders.is_subscription', 1)
        .where('orders.user_id', userId)
        .groupBy('orders.order_id');
        
        let totalReserveAmt = 0;
        reserveAmt.forEach(item => {
        totalReserveAmt += parseFloat(item.reserve_amount);
        });
        
        let actualWallet = (user.wallet - totalReserveAmt);
        
        // Store order details
        const storeDetailsAmt = await knex('store_orders')
        .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .where('store_orders.store_approval', userId)
        .where('store_orders.order_cart_id', 'incart')
        .where('subscription_flag', 1)
        .select(
        knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),
        knex.raw('SUM(store_orders.price) as Totalprice'),
        knex.raw('COUNT(store_orders.store_order_id) as count')
        )
        .first();
        
        let WalletDiscountAmount = ((parseFloat(storeDetailsAmt.Totalprice) * 50) / 100).toFixed(2);
        totalWalletAmt = (wallet.toLowerCase() === 'yes' && actualWallet >= WalletDiscountAmount) ? WalletDiscountAmount : actualWallet;
        }
    


    // Determine siStatus based on siSubRefNo
    const siStatus = siSubRefNo ? "yes" : "no";
    const hash = crypto.createHash('md5').update(String(Date.now())).digest('hex');
    const hashSubstring = hash.substring(0, 2); // Adjust substring length as needed
    // Combine all parts to form group_id
    const groupId = (paymentOrderId) ? paymentOrderId :generateRandomLetters(6) + generateRandomDigits(2) + hashSubstring;
    // Query address from the database
    const ar = await knex('address')
    .select('society', 'city', 'city_id', 'society_id', 'lat', 'lng', 'address_id','house_no','receiver_email','landmark')
    .where('user_id',userId) // Check if this is the correct condition for your use case
    .where('address_id', addressId)
    .first(); 

    if (!ar) {
    throw new Error('No address found for the provided user ID and address ID');
    }

        const ordersDetails = await knex('store_orders')
        .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .select('store_orders.*')
        .where('store_orders.store_approval', userId)
        .where('subscription_flag', 1)
        .where('store_orders.order_cart_id', "incart");

        // Get today's date and current time in Dubai timezone
        const dubaiTime = moment.tz("Asia/Dubai");
        const todayDubai = dubaiTime.format("YYYY-MM-DD");
        const isAfter6PM = dubaiTime.hour() > 17;

        // Condition 1: Check if any order has a sub_delivery_date of today
        ordersDetails.forEach(order => {
        if (order.sub_delivery_date === todayDubai) {
        throw new Error("Unable to place order for selected date time. Please select different date and time.");
        }
        });


        // Condition 2: If it's after 6 PM in Dubai, prevent placing orders for tomorrow with "06:00 am - 10:00 am" time slot
        if (isAfter6PM) {
        const tomorrowDubai = dubaiTime.add(1, 'day').format("YYYY-MM-DD"); // Get tomorrow's date in Dubai time
        ordersDetails.forEach(order => {
        if (order.sub_delivery_date == tomorrowDubai && order.sub_time_slot == "06:00 am - 10:00 am") {
        throw new Error(`Unable to place order for selected date time. Please select different date and time.`);
        }
        });
        }

        // Fetch user phone and wallet
        const user = await knex('users')
        .select('user_phone', 'wallet','country_code','user_phone','name','email')
        .where('id', userId)
        .first();
        let userPhone=user.country_code+user.user_phone;
        let userName=user.name;
        let userEmail=(user.email)?user.email:ar.receiver_email;
        // Calculate reserve amount
        const reserveAmt = await knex('orders')
        .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
        .select('orders.reserve_amount')
        .where('orders.is_subscription', 1)
        .where('orders.user_id', userId)
        .groupBy('orders.order_id');

        let totalReserveAmt = 0;
        reserveAmt.forEach(item => {
        totalReserveAmt += parseFloat(item.reserve_amount);
        });

    let actualWallet=(user.wallet-totalReserveAmt);
    let WalletBalanace=user.wallet-totalWalletAmt;
    if (!user) {
    throw new Error('User not found');
    }

    //store order details
    const storeDetailsAmt = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    .join('product','product_varient.product_id','=','product.product_id')
    .where('store_orders.store_approval',userId)
    .where('store_orders.order_cart_id', 'incart')
    .where('subscription_flag',1)
    .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
    .first(); 

    const TotalpriceAmount=(parseFloat(storeDetailsAmt.Totalprice)-parseFloat(totalWalletAmt));
    const WithWalletAmount=parseFloat(TotalpriceAmount)+parseFloat(totalWalletAmt);     
    const WalletDiscountAmount=((parseFloat(storeDetailsAmt.Totalprice)*50)/100).toFixed(2);
    const WalletStatus = (wallet.toLowerCase() === 'yes' && actualWallet >= WalletDiscountAmount) ? 'percentage' : 'fixed';

    if(siStatus == 'yes' && paymentType.toLowerCase() == 'paynow')
        {
        
        const BankDetails = await knex('tbl_user_bank_details')
        .where('si_sub_ref_no', siSubRefNo)
        .where('user_id', userId)
        .first();
    
        if (BankDetails) {
        // Success: BankDetails found   
        // TotalPay Credentials for Test/Live
        const recurring_init_trans_id=BankDetails.recurring_init_trans_id;
        // TotalPay Credentials for Test
        // const merchantKey = '968abd2e-79ce-11ef-8430-ee2650fd5759';
        // const merchantpassword = 'abdf10a546b5197cdf81508a3d3c9e23';
        // TotalPay Credentials for Live
        const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
        const merchantpassword = '96bb03851c3553fd132339acc06ce060';
        const recurring_token=BankDetails.si_sub_ref_no;
        const pay_amounts=TotalpriceAmount;
        const orderNumber=groupId;
        const orderDescription="Payment Deduction";
        const amount = (pay_amounts).toFixed(2); // Ensure two decimal places
    
        const hashData = `${recurring_init_trans_id}${recurring_token}${orderNumber}${amount}${orderDescription}${merchantpassword}`;
        const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');
        const mainJson = {
        merchant_key: merchantKey,
        recurring_init_trans_id:recurring_init_trans_id,
        recurring_token:recurring_token,
        hash,
        order:{
        number:groupId,
        amount:amount,
        description:orderDescription
        }
        };
    
        const jsonData = JSON.stringify(mainJson);
        const checkoutUrl = 'https://checkout.totalpay.global/api/v1/payment/recurring';
    
        try {
        const fetch = (await import('node-fetch')).default;
    
        const response = await fetch(checkoutUrl, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: jsonData,
        });

        const data = await response.json();
        const status = data.status.toLowerCase();
        if (status === 'decline' || status === 'pending') {
        const errorMessage = status === 'decline' 
        ? 'Card issue detected! Status: decline' 
        : `HTTP error! Status: ${data.status}`;
        throw new Error(errorMessage);
        }

        if (!response.ok) {
        throw new Error(`HTTP error! Status: ${response.status}`);
        }
        
        await knex('tbl_si_deduction_log').insert({
        si_sub_ref_no:siSubRefNo,
        user_id: userId,
        amount: parseFloat(TotalpriceAmount).toFixed(2),
        payment_method: 'SI',
        payment_status:0,
        card_id:groupId,
        });
        //return await response.json();
        } catch (error) {
        console.error('Error sending payment data:', error);
        throw error; // Re-throw for handling in the calling code
        }
    
    
        } else {
        // No BankDetails found
        throw new Error('No bank details found for the given criteria.');
        }
    }


     // Fetch orders
     const data_array = await knex('store_orders')
     .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
     .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
     .join('product', 'product_varient.product_id', '=', 'product.product_id')
     .select('store_orders.*')
     .where('store_orders.store_approval', userId)
     .where('subscription_flag',1)
     .where('store_orders.order_cart_id', "incart");

     let price2 = 0;
     let tax_p = 0;
     let tax_price = 0;
     let TotalpriceStore=storeDetailsAmt.Totalprice;
     for (const productList of data_array) {
         const { varient_id: varientId, qty: orderQty,store_order_id:storeOrderId,sub_total_delivery:subTotalDelivery,repeat_orders:repeatOrders,sub_delivery_date:subDeliveryDate,sub_time_slot:subTimeSlot } = productList;

         // Generate cart_id
         const hash = crypto.createHash('md5').update(String(Date.now())).digest('hex');
         const cartId = generateRandomLetters(4) + generateRandomDigits(2) + hash.substring(0, 2);

         const product = await knex('store_orders')
             .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
             .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
             .join('product', 'product_varient.product_id', '=', 'product.product_id')
             .select('store_orders.*', 'product.cat_id', 'product_varient.buying_price', 'store_products.mrp')
             .where('store_orders.order_cart_id', 'incart')
             .where('store_orders.varient_id', varientId)
             .where('store_orders.store_id', storeId)
             .where('store_orders.store_approval', userId)
             .where('subscription_flag',1)
             .first();
 
         if (!product) {
             throw new Error('Product not found');
         }
 
         const { price, mrp, tx_per: taxPer, tx_price: taxPrice, min_ord_qty: minOrderQty, max_ord_qty: maxOrderQty, stock, product_name: productName, quantity, unit, varient_image: varientImage } = product;
         const totalMrp = mrp; // Adjust this if needed
         price2=price;
        
         const totalPrice =parseFloat(price2);
         
         let paidByWallet=0;

         if(wallet.toLowerCase() === 'yes'){
          if(WalletStatus == 'percentage'){
             paidByWallet=(parseFloat(totalPrice)*50)/100;
          }else
          {
             paidByWallet=(parseFloat(totalPrice)*parseFloat(totalWalletAmt))/parseFloat(WithWalletAmount);  
          }
         }
         
         const paymentStatus = (paymentType.toLowerCase() === 'payperdelivery') ? 'Pending' : 'success';
         const remPrice=(paymentType.toLowerCase() === 'payperdelivery') ? (totalPrice-paidByWallet) : 0;
         const siPaymentFlag=(paymentType.toLowerCase() === 'payperdelivery') ? 'no' : 'yes';
         const siOrder=(paymentType.toLowerCase() === 'payperdelivery') ? 'yes' : 'no';
         const reserveAmount=(paymentType.toLowerCase() === 'payperdelivery') ? paidByWallet : 0;
         
       
         const orderID =await knex('orders')
         .insert({
         cart_id: cartId,
         total_price: totalPrice.toFixed(2),
         price_without_delivery: totalPrice.toFixed(2),
         total_products_mrp: totalPrice.toFixed(2),
         delivery_charge:0,
         user_id: userId,
         store_id: storeId,
         rem_price:(remPrice)? parseFloat(remPrice).toFixed(2):0,
         order_date: current,
         delivery_date: subDeliveryDate,
         time_slot: subTimeSlot,
         address_id: addressId,
         avg_tax_per: 0,
         total_tax_price: 0,
         total_delivery: subTotalDelivery, // Adjust if needed
         repeat_orders:repeatOrders,
         is_subscription:isSubscription,
         del_partner_tip:0,
         del_partner_instruction:'',
         order_instruction:order_instruction,
         group_id: groupId, // Use groupId for group_id or adjust as needed
         cod_charges:0,
         paid_by_wallet:(paidByWallet)? parseFloat(paidByWallet).toFixed(2): 0,
         payment_method:paymentMethod,
         coupon_id:0,
         coupon_code:0,
         coupon_discount:0,
         payment_status:paymentStatus,
         payment_type:paymentType,
         si_sub_ref_no:siSubRefNo,
         bank_id:bankId,
         si_order:siOrder,
         reserve_amount:parseFloat(reserveAmount).toFixed(2),
         pastorecentrder:'new'
         }).returning('order_id');
   
         await knex('store_orders')
         .where('store_order_id',storeOrderId)
         .update({
         'order_cart_id':cartId,
         }); 
         
        // if(AutoRenewSubCart == 'yes'){
        //     await knex('store_orders')
        //     .where('store_order_id',storeOrderId)
        //     .update({
        //     'isautorenew':"yes",
        //     }); 
        // }
        
         let k=0;
         const repeatOrderss = repeatOrders.trim().split(',');
         const totalDeliveryWeek=repeatOrderss.length*subTotalDelivery;
         for(let i=0; i<1000; i++)  
         {
            const deliveryDates = moment(subDeliveryDate).add(i, 'days').format('YYYY-MM-DD');
           for(let j=0;j<repeatOrderss.length;j++)
           {
            const timestamp = moment(deliveryDates).toDate().getTime();
            const day = moment(deliveryDates).format('ddd');
            const days_name = repeatOrderss[j].trim();
            if(days_name.toLowerCase() == day.toLowerCase()){
            
            const getSub =await knex('subscription_order')
            .select('id')
            .orderBy('id','DESC')
            .first();
            let subscription_id=(getSub)?getSub.id:0;
            subscription_id=subscription_id+1;

            const subscriptionID = await knex('subscription_order')
            .insert({
            'store_order_id':storeOrderId,
            'cart_id':cartId,
            'user_id':userId,
            'order_id':orderID,
            'store_id':storeId,
            'delivery_date':deliveryDates,
            'time_slot':subTimeSlot,
            'created_date': current,
            'order_status':'Pending',
            'si_payment_flag':siPaymentFlag,
            'group_id':groupId,
            'subscription_id':subscription_id
            }); 
            k++;
            }
           }
           if(k == totalDeliveryWeek)
            {
            break;
            }

         }    

     }

    if(paymentType.toLowerCase() == 'paynow' && totalWalletAmt > 0)
    {
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', userId)
    .first();
    let actualWallet=user.wallet-totalWalletAmt;

    await knex('users')
    .where('id', userId)
    .update({
    'wallet':actualWallet,
    }); 

    await knex('wallet_history').insert({
    user_id: userId,
    amount: parseFloat(totalWalletAmt).toFixed(2),
    resource: 'Deduction',
    type:'Deduction',
    group_id:groupId,
    cart_id:"",
    });

    }

   
    //SMS Code
    message = "You have successfully subscribed to QuicKart! Your order "+groupId+" will be delivered right on schedule.";
    sendSMSOrder(userPhone,message);

    //Email Code 
    totalCal = await knex('orders')
    .where('group_id', groupId)
    .sum('coupon_discount as coupon_discount')
    .sum('rem_price as rem_price')
    .sum('paid_by_wallet as paid_by_wallet')
    .sum('cod_charges as cod_charges')
    .sum('total_products_mrp as total_products_mrp');


    storeOrders = await knex('store_orders')
    .select('store_orders.*','orders.group_id','orders.time_slot','orders.total_delivery')
    .join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
    .where('orders.group_id', groupId)

    finalAmount = parseFloat(totalCal[0].total_products_mrp).toFixed(2);
    const logo = await knex('tbl_web_setting').first();
    const appName = logo ? logo.name : null;
    // Fetching the first record from the 'currency' table
    const currency = await knex('currency').first();
    const currencySign = currency ? currency.currency_sign : null;
    // Get the year, month, and day in the required format
    const year = current.getFullYear();
    const month = String(current.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
    const day = String(current.getDate()).padStart(2, '0');
    // Combine into the desired format
    const formattedDate = `${year}-${month}-${day}`;
    
    const startsubdate = await knex('subscription_order')
    .select('delivery_date')
    .where('group_id', groupId)
    .orderBy('delivery_date', 'asc')
    .first();

    const date1 = new Date(startsubdate.delivery_date);
    // Get the year, month, and day in the required format
    const year1 = date1.getFullYear();
    const month1 = String(date1.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
    const day1 = String(date1.getDate()).padStart(2, '0');
    // Combine into the desired format
    const formattedstartDate = `${year1}-${month1}-${day1}`;
    const endsubdate  = await knex('subscription_order')
    .select('delivery_date')
    .where('group_id', groupId)
    .orderBy('delivery_date', 'desc')  // Sort by start_date in ascending order
    .first()
    const date2 = new Date(endsubdate.delivery_date);
    // Get the year, month, and day in the required format
    const year2 = date2.getFullYear();
    const month2 = String(date2.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
    const day2 = String(date2.getDate()).padStart(2, '0');
    // Combine into the desired format
    const formattedendDate = `${year2}-${month2}-${day2}`;


    const templateData = {
    baseurl: process.env.base_url,
    group_id: groupId,
    user_name: userName,
    user_email: userEmail,
    delivery_date:deliveryDate,
    orderss_address:ar.house_no+', '+ar.landmark+', '+ar.society,
    store_orderss:storeOrders,
    coupon_discount:totalCal[0].coupon_discount.toFixed(2),
    paid_by_wallet:totalCal[0].paid_by_wallet.toFixed(2),
    cod_charges:totalCal[0].cod_charges.toFixed(2),
    final_amount:finalAmount,
    app_name:appName,
    currency_sign:currencySign,
    order_type:"subscription",
    startdelivery_date:formattedstartDate,
    enddelivery_date:formattedendDate,
    order_date:formattedDate,
    paymentMethod:paymentMethod,
    };
    const subject = 'Order Successfully Placed'
    // Trigger the email after order is placed
    sendMail = await codorderplacedMail(userEmail, templateData,subject,groupId);


    
    return "success";
};


// Generate random letters, digits, and hash substring
const generateRandomLetters = (length) => {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    let result = "";
    for (let i = 0; i < length; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
};

const generateRandomDigits = (length) => {
    const chars = "0123456789";
    let result = "";
    for (let i = 0; i < length; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
};

const sendSMSOrder = async (phoneNumber, message) => {
    const user_name = process.env.SMARTVISION_LOGIN;
    const password = process.env.SMARTVISION_PASSWORD;
    const user_phone = phoneNumber; // Replace with the actual phone number
    // const Contacts = "971" + user_phone;
    const SenderId = "Quickart";
    const url = `https://rslr.connectbind.com:8443/bulksms/bulksms?username=${user_name}&password=${password}&type=0&dlr=1&destination=${user_phone}&source=${SenderId}&message=${encodeURIComponent(message)}`;
    axios.get(url)
    .then(response => {
    console.log('Response:', response.data);
    })
    .catch(error => {
    console.error('Error:', error);
    });
    };

module.exports = {
getSubordercheckout,
getQuickordercheckout
};