// models/homeappModel.js
const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const { format } = require('date-fns');
const moment = require('moment');


const getorderList = async (appDetatils) => {
  const { store_id } = appDetatils;
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;

  // Fetch all orders
  const orders = await knex('orders')
    .select('orders.cart_id', 'orders.group_id', 'orders.is_subscription','orders.order_date')
    .where('orders.user_id', user_id)
    .whereNotNull('orders.payment_method')
    .whereNot('orders.order_status', null)
    .orderBy('orders.order_id', 'desc')
    .groupBy('orders.group_id')
    .limit(8);

  if (orders.length === 0) {
    return []; // Return an empty array if no orders are found
  }

  // Extract all group_ids
  const groupIds = orders.map(order => order.group_id);
  const orderData = await knex('orders')
    .whereIn('group_id', groupIds)
    .select('cart_id', 'group_id'); // Fetch cart_id and group_id
    
    


if (orderData.length === 0) {
  return Promise.all(
    orders.map(async (order) => {
      const ordtotalprice = await knex('orders')
        .whereIn('group_id', [order.group_id]) // Ensure array format for whereIn
        .sum('total_price as total');

      return {
        cart_id: order.cart_id,
        group_id: order.group_id,
        order_date: order.order_date,
        ordtotalprice: ordtotalprice[0]?.total || 0, // Handle possible undefined
        type: order.is_subscription === 1 ? 'Subscription' : 'Quick',
        is_subscription: order.is_subscription,
        prodList: [] // Empty product list if no data
      };
    })
  );
}

  // Fetch all store orders in one query
  const cartIds = orderData.map(data => data.cart_id);
  const storeOrders = await knex('store_orders')
    .whereIn('order_cart_id', cartIds)
    .where('store_id', store_id)
    .select('store_order_id','order_cart_id', 'product_name', knex.raw(`CONCAT('${baseurl}', varient_image) as varient_image`));

  // Group store orders by cart_id for easy lookup
  const storeOrderMap = {};
  storeOrders.forEach(order => {
    if (!storeOrderMap[order.order_cart_id]) {
      storeOrderMap[order.order_cart_id] = [];
    }
    storeOrderMap[order.order_cart_id].push(order);
  });

  // Create the final customized product data
const customizedProductData = await Promise.all(
  orders.map(async (order) => {
    const typeval = order.is_subscription === 1 ? 'Subscription' : 'Quick';

    // Fetch total price for the group_id
    const ordtotalprice = await knex('orders')
      .whereIn('group_id', [order.group_id]) // Ensure array format for whereIn
      .sum('total_price as total');

    // Get the list of cart_ids for the current order
    const orderCartIds = orderData
      .filter(data => data.group_id === order.group_id)
      .map(data => data.cart_id);

    // Get the product list for the current order's cart_ids
    const prodList = orderCartIds.flatMap(cart_id => storeOrderMap[cart_id] || []); // Use || [] to avoid undefined

    return {
      cart_id: order.cart_id,
      group_id: order.group_id,
      order_date: order.order_date,
      ordtotalprice: ordtotalprice[0]?.total || 0, // Handle potential undefined value
      type: typeval,
      is_subscription: order.is_subscription,
      prodList: prodList
    };
  })
);


  return customizedProductData;
};

const getfeaturecat = async (appDetatils) => {
const {store_id,user_id,is_subscription}=appDetatils;
const baseurl =  process.env.BUNNY_NET_IMAGE;
return await knex('feature_categories')
.select(
'feature_categories.id',
'feature_categories.title',
knex.raw(`CONCAT('${baseurl}', feature_categories.image) as image`)
)
.join('product', function () {
this.on(knex.raw(`FIND_IN_SET(feature_categories.id, product.fcat_id)`));
})
.where('feature_categories.is_deleted', 0)
.where('feature_categories.status', 1)
.groupBy('feature_categories.id')
.orderBy('feature_categories.order', 'ASC')
.limit(18);
};

const trailpackimagedata = async (appDetatils) => {
  const {store_id,user_id,is_subscription}=appDetatils;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
      //const today = new Date()
       const today = new Date().toISOString().split('T')[0];
       const orderlistdata =  await knex('orders')
                  .where('order_type', 'LIKE', 'trail')
                  .where('user_id',appDetatils.user_id)
                  .groupBy('trail_id')
                  .pluck('trail_id');
                  
      const checktrail =  await knex('tbl_trail_pack_basic')
      .where('tbl_trail_pack_basic.status', 1)
      .where('tbl_trail_pack_basic.start_date', '<=', today)
      .andWhere('tbl_trail_pack_basic.end_date', '>=', today)
      .where('tbl_trail_pack_basic.is_delete', 0)
       .whereNotIn('id',orderlistdata)
       .orderBy('main_order', 'ASC')
      .select('id','popup_image','image')
      .first();

      if(checktrail){
          trailimage = checktrail.image;
        //trailpackimage =  baseurl + "/images/trail_pack/trialpack.png"
        return trailpackimage =  baseurl + trailimage;

      }else{
        return  trailpackimage =  null;
      }

  
};

const getBanner = async (appDetatils) => {
   const { store_id, user_id, is_subscription } = appDetatils;
   const baseurl =  process.env.BUNNY_NET_IMAGE;
    const banners = await knex('store_banner')
    .select('banner_id', 'banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
    .where('store_id', store_id)
    .where('is_delete','!=',1)
    .where('status',1)
    .orderBy('store_banner.sequence', 'asc')
    .limit(8);

    // Append ?width=500&height=500&quality=100 to each banner image URL
    return banners.map(banner => ({
    ...banner,
    banner_image: `${banner.banner_image}?width=700&height=700&quality=100`
    }));

};  

const getBrand = async (appDetatils) => {
    const { store_id, user_id, is_subscription } = appDetatils;
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return brand = await knex('brands')
     .select('cat_id','title',  knex.raw(`CONCAT('${baseurl}', image) as image`))
     .orderBy('cat_id', 'asc')
     .limit(8);
 
};

const getBrandlist = async () => {
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return brand = await knex('brands')
     .select('brands.cat_id','brands.title',  knex.raw(`CONCAT('${baseurl}', brands.image) as image`))
     .join('product','product.brand_id','brands.cat_id')
     .groupBy('product.brand_id')
     .orderBy('brands.cat_id', 'asc');
};

const getaboutData = async () => {
       return about = await knex('aboutuspage')
       .first();
   
};

const gettermsData = async () => {
       return terms = await knex('termspage')
       .first();
   
};

const getTopCat = async (appDetatils) => {
  const {store_id,user_id,is_subscription}=appDetatils;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
//   return await knex('categories')
//   .select('title','cat_id','description',knex.raw(`CONCAT('${baseurl}', image) as image`) )
//   .where('level',0)
//   .orderBy('sequence_list','ASC')
//   .limit(18);

      return await knex('categories')
          .join('categories as cat', 'categories.cat_id', 'cat.parent')
          .join('product', 'cat.cat_id', 'product.cat_id')
          .join('product_varient', 'product.product_id', 'product_varient.product_id')
          .join('store_products', 'product_varient.varient_id', 'store_products.varient_id')
          .select('categories.title', 'categories.cat_id', knex.raw(`CONCAT('${baseurl}', categories.image) as image`), 'categories.description')
          .groupBy('categories.cat_id')
          .where('categories.level', 0)
          .where('categories.is_delete', 0)
          .orderBy('categories.sequence_list', 'ASC')
          .limit(18);
  
};

const getWhatsNew = async (appDetatils) => {
    const {store_id,is_subscription} =appDetatils;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    const storeId = store_id;
    const categoryId = 37;
    
    
    const productDetails = await knex('store_products')
      .select(
        'store_products.store_id',
        'product.cat_id',
        'store_products.stock',
        'product_varient.varient_id',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.description',
        'store_products.price',
        'store_products.mrp',
        'product_varient.varient_image',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.country_id',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .innerJoin('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .whereNotNull('store_products.price')
      .where('store_products.store_id', storeId)
      .where('product.is_subscription', 1)
      .where('product.hide', 0)
      .where('product.is_delete', 0)
      //.where('product.cat_id', categoryId)
      .orderBy('product.product_name', 'desc')
      .limit(8);
      const baseurl =  process.env.BUNNY_NET_IMAGE;
      const customizedProductData = [];
      for (let i = 0; i < productDetails.length; i++) {
        const ProductList = productDetails[i];
  
        var cartQty=0;
        if(user_id){ 
          // Wishlist check 
           // Wishlist check 
           var isFavourite='';
            var notifyMe='';
            var cartQty=0;
           const wishList = await knex('wishlist')
          .select('*')
          .where('varient_id',ProductList.varient_id)
          .where('user_id',user_id);
  
          isFavourite = wishList.length > 0 ? 'true' : 'false';
   
          // cart qty check 
          const CartQtyList = await knex('store_orders')
          .where('varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('order_cart_id','incart')
          .whereNull('subscription_flag')
          .where('store_id',store_id)
          .first();
          cartQty = CartQtyList ? CartQtyList.qty : 0;

            try {
            const cnotify_me = await knex('product_notify_me')
            .where('varient_id', ProductList.varient_id)
            .where('user_id', user_id);

            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

            if (cnotify_me.length === 0) {
            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
            } else {
            notifyMe='false';
            }
            } catch (error) {
            notifyMe='false';
            }

           const subprod = await knex('store_orders')
           .select('store_orders.percentage')
           .where('store_orders.varient_id',ProductList.varient_id)
           .where('store_approval',user_id)
           .where('store_orders.subscription_flag',1)
           .where('store_orders.order_cart_id', "incart")
           .first();
   
           if(subprod){
             isSubscription = 'true'
           }else{
             isSubscription = 'false'
             
           }
  
  
          }else{
           notifyMe='false';
           isFavourite='false';
           cartQty=0;
           isSubscription = 'false';

          }
          
          const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
          const finalsubprice =  ProductList.mrp - sub_price;
          const subscription_price = parseFloat(finalsubprice.toFixed(2));
          
          if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
          
          const customizedProduct={
          store_id:ProductList.store_id,
         // is_subscription:ProductList.is_subscription,
          stock: ProductList.stock,      
          varient_id: ProductList.varient_id,
          product_id: ProductList.product_id,  
          product_name: ProductList.product_name,
          product_image:baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
          thumbnail: baseurl + ProductList.thumbnail,
          price: ProductList.price,
          mrp: ProductList.mrp,
          unit: ProductList.unit,
          quantity: ProductList.quantity,
          type: ProductList.type,  
         // discountper: ProductList.discountper, 
          discountper:0,
          country_icon : countryicon,   
          percentage: ProductList.percentage,
          isSubscription:isSubscription,
          subscription_price:subscription_price, 
          availability:ProductList.availability,
          cart_qty: cartQty,
          avgrating:0,
          notify_me: notifyMe,
          isFavourite: isFavourite
          // Add or modify properties as needed
          };
        customizedProductData.push(customizedProduct);  
      }
      
      return customizedProductData;
};

const getdealProduct = async (appDetatils) => {
    const {store_id,is_subscription} =appDetatils;
    const storeId = store_id;
    const currentDate = new Date().toISOString().split('T')[0];

    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
 const deal_pssss = await knex('deal_product')
  .join('store_products', 'deal_product.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'deal_product.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
  .select(
    'store_products.stock',
    'deal_product.deal_price as price',
    'product_varient.quantity',
    'product_varient.unit',
    'store_products.mrp',
    'product.product_name',
    'product.product_image',
    'product.thumbnail',
    'product_varient.varient_id',
    'product.product_id',
    'deal_product.valid_to',
    'deal_product.valid_from',
    'product.type',
    'tbl_country.country_icon',
    'product.percentage',
    'product.availability',
  )
  .groupBy(
    'store_products.store_id',
    'store_products.stock',
    'deal_product.deal_price',
    'product_varient.varient_image',
    'product_varient.quantity',
    'product_varient.unit',
    'store_products.mrp',
    'product_varient.description',
    'product.product_name',
    'product.product_image',
    'product_varient.varient_id',
    'product.product_id',
    'deal_product.valid_to',
    'deal_product.valid_from',
    'product.type'
  )
  .where('deal_product.valid_from', '<=', currentDate)
  .where('deal_product.valid_to', '>', currentDate)
  .whereNotNull('store_products.price')
  .where('product.hide', 0)
  .where('product.is_delete', 0)
  .where('deal_product.store_id', storeId)
 // .where('product.is_subscription', is_subscription)
  .orderBy('product.product_name', 'asc')
  .limit(8);
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  const productDetailss = deal_pssss.filter((product, index, self) => {
    return index === self.findIndex((p) => p.product_id === product.product_id);
    });
    const customizedProductData = [];
    for (let i = 0; i < productDetailss.length; i++) {
      const ProductList = productDetailss[i];

      var cartQty=0;
      if(user_id && ProductList){ 
        const CartQtyList = await knex('store_orders')
        .where('varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('order_cart_id','incart')
        .whereNull('subscription_flag')
        .where('store_id',store_id)
        .first();
        cartQty = CartQtyList ? CartQtyList.qty : 0;

        const subprod = await knex('store_orders')
        .select('store_orders.percentage')
        .where('store_orders.varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('store_orders.subscription_flag',1)
        .where('store_orders.order_cart_id', "incart")
        .first();

        if(subprod){
          isSubscription = 'true'
        }else{
          isSubscription = 'false'
          
        }

       }else{
          isSubscription = 'false'
       }

       const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
       const finalsubprice =  ProductList.mrp - sub_price;
       const subscription_price = parseFloat(finalsubprice.toFixed(2));
       
       if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }

        const customizedProduct={
        stock: ProductList.stock,        
        price: ProductList.price,
        quantity: ProductList.quantity,
        unit: ProductList.unit,
        mrp: ProductList.mrp,
        product_name: ProductList.product_name,
        product_image:baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
        thumbnail: ProductList.thumbnail,
        varient_id: ProductList.varient_id,
        product_id: ProductList.product_id,
        valid_to: ProductList.valid_to,
        valid_from: ProductList.valid_from,
        type: ProductList.type,
        cart_qty: cartQty,
        country_icon : countryicon, 
        percentage: ProductList.percentage,
        isSubscription:isSubscription,
        subscription_price:subscription_price,
        availability:ProductList.availability,  
        // Add or modify properties as needed
        };
      customizedProductData.push(customizedProduct);  
    }

    
     
   return customizedProductData; 
};

const getsecondBanner = async (appDetatils) => {
  const {store_id,user_id,is_subscription} = appDetatils;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  return await knex('sec_banner')
  .where('sec_banner.store_id', store_id)
  .where('sec_banner.is_delete',0)
   .where('sec_banner.status',1)
  .select('sec_banner.banner_id','sec_banner.brand_id', 'sec_banner.banner_name',knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
  .orderBy('sec_banner.seq', 'ASC')
  .limit(6);
};

const sneakyOfferBanner = async (appDetatils) => {
    const {store_id,user_id,is_subscription} = appDetatils;
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return await knex('sneaky_banner')
     .select('banner_id','banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
     .where('store_id',store_id)
     .orderBy('banner_id','DESC')
     .first(); 
};

const popupBanner = async (appDetatils) => {
  const { store_id, user_id, is_subscription } = appDetatils;
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const popupbanner = await knex('popup_banner')
      .select('banner_id', 'banner_name', 'type', 'trail_id', 'search_by',
          knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
      .where('store_id', store_id)
      .orderBy('banner_id', 'DESC')
      .first();
      
 // return popupbanner.type;

  // If no popupbanner found, return empty array
  if (!popupbanner) {
      return null;
  }

  // If trail_id exists
  if (popupbanner.type == 'trial') {
    const today = new Date().toISOString().split('T')[0];
    const checktraillist = await knex('tbl_trail_pack_basic')
    .where('status', 1)
    .where('start_date', '<=', today)
    .where('end_date', '>=', today)
    .where('is_delete', 0)

    if (!checktraillist) {
      return null;
    }
     
      const orderlist = await knex('orders')
          .where('order_type', 'LIKE', 'trail')
          .where('user_id', user_id)
          .groupBy('trail_id')
          .pluck('trail_id');

      const storeproduct = await knex('tbl_trail_pack_deatils')
          .join('store_products', 'tbl_trail_pack_deatils.varient_id', '=', 'store_products.varient_id')
          .where('store_products.stock', 0)
          .pluck('tbl_trail_pack_deatils.varient_id');

      const trialidlist = await knex('tbl_trail_pack_deatils')
          .whereIn('varient_id', storeproduct)
          .pluck('tbl_trail_pack_deatils.trail_id');

      const uniqueValues = [...new Set(trialidlist)];

      

      if(orderlist){
      const checktrail = await knex('tbl_trail_pack_basic')
          .where('status', 1)
          .where('start_date', '<=', today)
          .where('end_date', '>=', today)
          .where('is_delete', 0)
          .whereNotIn('id', uniqueValues)
          .whereNotIn('id', orderlist)
          .orderBy('main_order', 'ASC')
          .select('id','popup_image','image','title')
         .first();
         
          if(checktrail){
            trailimage = checktrail.popup_image;
           trailpackimage =  baseurl + trailimage;
           checktrailid =checktrail.id;
           checktrailtitle = checktrail.title;
        
  
        }else{
            // trailpackimage =  null;
            // checktrailid =null;
            // checktrailtitle = null;
          
            return  null;
        } 
         
      }else{
        //   trailpackimage =  null;
        //   checktrailid =null;
        //   checktrailtitle = null;
         
        return null;
      }

      // const popuplist = await knex('popup_banner')
      //     .select('banner_id', 'banner_name', 'type', 'trail_id', 'search_by',
      //         knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
      //     .where('store_id', store_id)
      //     .whereIn('trail_id', trailIdarray)
      //     .orderBy('banner_id', 'DESC')
      //     .first();
          
        
        const popuplist = {
          banner_id: checktrailid,
          banner_name: checktrailtitle,
          type: "trial",
          trail_id: checktrailid,
          search_by: null,
          banner_image: trailpackimage
        };
        
        
        
       
          
         // popuplist.push(popuplist);
          

      return popuplist ? popuplist : null;
  } else {
      // Recheck in case trail_id is not present
      const popuplist = await knex('popup_banner')
          .select('banner_id', 'banner_name', 'type', 'trail_id', 'search_by',
              knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
          .where('store_id', store_id)
          .orderBy('banner_id', 'DESC')
          .first();

      return popuplist ? popuplist : null;
  }
};

const specialOfferBanner = async (appDetatils) => {
      const {store_id,user_id,is_subscription} = appDetatils;
      const baseurl =  process.env.BUNNY_NET_IMAGE;
       return await knex('special_offers_banner')
       .select('banner_id','banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
       .where('store_id',store_id)
       .orderBy('banner_id','DESC')
       .limit(6); 
};

const similarProds = async (appDetatils, catId) => {
    const cat_id = catId;
    const store_id = appDetatils.store_id;

    const prod = await knex('store_products')
        .select(
            'store_products.store_id',
            'product.cat_id',
            'store_products.stock',
            'product_varient.varient_id',
            'product.product_id',
            'product.product_name',
            'product.product_image',
            'product.thumbnail',
            'product_varient.description',
            'store_products.price',
            'store_products.mrp',
            'product_varient.varient_image',
            'product_varient.unit',
            'product_varient.quantity',
            'product.type',
            'product.country_id',
            'tbl_country.country_icon',
            'product.percentage',
            'product.availability',
            'product.fcat_id',
            knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
        )
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .where('product.cat_id', cat_id)
        .where('store_products.store_id', store_id)
        .whereNotNull('store_products.price')
        .where('product.hide', 0)
        .where('product.is_delete', 0)
        .where('product.approved', 1)
        .limit(5);

    let user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;

    const customizedProductData = [];

    for (let i = 0; i < prod.length; i++) {
        const ProductList = prod[i];
        const currentDate = new Date();

        const deal = await knex('deal_product')
            .where('varient_id', ProductList.varient_id)
            .where('store_id', appDetatils.store_id)
            .where('deal_product.valid_from', '<=', currentDate)
            .where('deal_product.valid_to', '>', currentDate)
            .first();

        let price;
        if (deal) {
            price = deal.deal_price;
        } else {
            const sp = await knex('store_products')
                .where('varient_id', ProductList.varient_id)
                .where('store_id', appDetatils.store_id)
                .first();
            price = sp.price;
        }

        let isFavourite = 'false';
        let notifyMe = 'false';
        let cartQty = 0;
        let isSubscription = 'false';

        if (user_id) {
            const wishList = await knex('wishlist')
                .select('*')
                .where('varient_id', ProductList.varient_id)
                .where('user_id', user_id);

            isFavourite = wishList.length > 0 ? 'true' : 'false';

            const CartQtyList = await knex('store_orders')
                .where('varient_id', ProductList.varient_id)
                .where('store_approval', user_id)
                .where('order_cart_id', 'incart')
                .whereNull('subscription_flag')
                .where('store_id', appDetatils.store_id)
                .first();

            cartQty = CartQtyList ? CartQtyList.qty : 0;

            try {
                const cnotify_me = await knex('product_notify_me')
                    .where('varient_id', ProductList.varient_id)
                    .where('user_id', user_id);

                notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
            } catch (error) {
                notifyMe = 'false';
            }

            const subprod = await knex('store_orders')
                .select('store_orders.percentage')
                .where('store_orders.varient_id', ProductList.varient_id)
                .where('store_approval', user_id)
                .where('store_orders.subscription_flag', 1)
                .where('store_orders.order_cart_id', 'incart')
                .first();

            isSubscription = subprod ? 'true' : 'false';
        }

        const baseurl = process.env.BUNNY_NET_IMAGE;

        const tag = await knex('tags')
            .where('product_id', ProductList.product_id);
        let tags = tag;

        let feature_tags = [];
        if (ProductList.fcat_id != null) {
            const resultArray = ProductList.fcat_id.split(',').map(Number);
            const ftaglist = await knex('feature_categories')
                .whereIn('id', resultArray)
                .where('status', 1)
                .where('is_deleted', 0)
                .select('id', knex.raw(`CONCAT('${baseurl}', image) as image`));
            feature_tags = ftaglist;
        }

        const images = await knex('product_images')
            .select(knex.raw(`CONCAT('${baseurl}', image) as image`))
            .where('product_id', ProductList.product_id)
            .orderBy('type', 'DESC');

        let imageslist;
        if (images.length > 0) {
            imageslist = images;
        } else {
            const fallbackImage = await knex('product')
                .select(knex.raw(`CONCAT('${baseurl}', product_image) as image`))
                .where('product_id', ProductList.product_id);
            imageslist = fallbackImage;
        }

        const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
        const finalsubprice = ProductList.mrp - sub_price;
        const subscription_price = parseFloat(finalsubprice.toFixed(2));

        let countryicon = ProductList.country_icon ? baseurl + ProductList.country_icon : null;

        const customizedProduct = {
            stock: ProductList.stock,
            varient_id: ProductList.varient_id,
            product_id: ProductList.product_id,
            product_name: ProductList.product_name,
            product_image: `${baseurl}${ProductList.product_image}?width=200&height=200&quality=100`,
            country_icon: countryicon,
            thumbnail: ProductList.thumbnail,
            description: ProductList.description,
            price: ProductList.price,
            mrp: ProductList.mrp,
            unit: ProductList.unit,
            quantity: ProductList.quantity,
            type: ProductList.type,
            percentage: ProductList.percentage,
            isSubscription: isSubscription,
            subscription_price: subscription_price,
            availability: ProductList.availability,
            discountper: 0,
            avgrating: 0,
            notify_me: notifyMe,
            isFavourite: isFavourite,
            cart_qty: cartQty,
            countrating: 0,
            tags: tags,
            feature_tags: feature_tags,
            images: imageslist,
            varients: null
        };

        customizedProductData.push(customizedProduct);
    }

    return customizedProductData;
};


const prodDetails = async(appDetatils) => {
    //const prod =

    
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    
    let prod = await knex('store_products')
    .select(
      'store_products.store_id',
      'store_products.stock',
      'product_varient.varient_id',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'store_products.price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      'product.available_days',
      'tbl_country.country_icon',
      'tbl_country.country_name as country_of_origin',
      'product.shelf_life',
      'product.percentage',
      'product.availability',
      'product.fcat_id',
      knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
    )
    .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
    .innerJoin('product', 'product_varient.product_id', 'product.product_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .where('store_products.store_id', appDetatils.store_id)
    //.where('product.is_subscription', appDetatils.is_subscription)
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('product.product_id',appDetatils.product_id)
    .where('product.approved', 1)
    .whereNotNull('store_products.price')
    .orderByRaw('RAND()')
    .first();
   
    

    const baseurl =  process.env.BUNNY_NET_IMAGE;
    prod.product_image = baseurl + prod.product_image+"?width=200&height=200&quality=100";
    
    if(prod.country_icon == null){
        countryicon = null
     }else{
        countryicon =  baseurl + prod.country_icon
     }
    prod.country_icon =  countryicon;
    

    const currentDate = new Date();
    const deal = await knex('deal_product')
    .where('varient_id',prod.varient_id)
    .where('store_id',appDetatils.store_id)
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .first();
   
  
      if (deal) {
        prod.price = deal.deal_price;
      } else {
      const sp = await knex('store_products')
      .where('varient_id', prod.varient_id)
      .where('store_id', appDetatils.store_id)
      .first();
        prod.price = sp.price;
      }
   
       
      if(user_id){ 
       




        // Wishlist check 
         // Wishlist check 
         var isFavourite='';
        var notifyMe='';
        var cartQty=0;
        var percentage = prod.percentage
        var isSubscription = '';
        if (user_id) {
         const wishList = await knex('wishlist')
        .select('*')
        .where('varient_id',prod.varient_id)
        .where('user_id',user_id);

        prod.isFavourite = wishList.length > 0 ? 'true' : 'false';
        }else
        {
        prod.isFavourite ='false';
        }

        // const subprod = await knex('subscribe_product')
        // .select('percentage')
        // .where('varient_id',prod.varient_id)
        // .where('user_id',appDetatils.user_id)
        // .first();

       
        const subprod = await knex('store_orders')
        .select('store_orders.percentage')
        .where('store_orders.varient_id',prod.varient_id)
        .where('store_approval',user_id)
        .where('store_orders.subscription_flag',1)
        .where('store_orders.order_cart_id', "incart")
        .first();

        if(subprod){
          prod.isSubscription = 'true'
        }else{
          prod.isSubscription = 'false'
          
        }
 
        // cart qty check 
        const CartQtyList = await knex('store_orders')
        .where('varient_id',prod.varient_id)
        .where('store_approval',user_id)
        .where('order_cart_id','incart')
        .whereNull('subscription_flag')
        .where('store_id',appDetatils.store_id)
        .first();
        prod.cartQty = CartQtyList ? CartQtyList.qty : 0;

        const cnotify_me = await knex('product_notify_me')
        .where('varient_id', prod.varient_id)
        .where('user_id', user_id)
        .first();
        prod.notifyMe = (cnotify_me) ? 'true' : 'false';
        }else{
          prod.notifyMe='false';
          prod.isFavourite='false';
          prod.cartQty=0;
          prod.isSubscription = 'false'
        }

        const getrating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id);
        prod.avgrating= 0;   
        if(getrating) {
        const countrating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id)
        .count('rate_id as totalCount'); 

        const rating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id)
        .avg('rating as averageRating');
        if(rating[0].averageRating == null){
        prod.avgrating= 0;
        }else{
        prod.avgrating=(rating[0].averageRating).toFixed(2); 
        }
        prod.countrating=countrating[0].totalCount;
        } 
        else{
        prod.avgrating=0; 
        prod.countrating=0;
        }  
        //return prod;
         
   
      const tag = await knex('tags') 
                 .where('product_id', prod.product_id);
      prod.tags = tag;  

                       if(prod.fcat_id != null){
                              fcatinput = prod.fcat_id;
                              const resultArray = fcatinput.split(',').map(Number);
                              const ftaglist = await knex('feature_categories') 
                                        .where('status',1)
                                        .where('is_deleted', 0)
                                        .whereIn('id', resultArray)
                                        .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
                              prod.feature_tags  = ftaglist
                            }
       
                  const images =  await knex('product_images') 
                  .select(knex.raw(`CONCAT('${baseurl}', image) as image`))
                  .where('product_id', prod.product_id)
                  .orderBy('type','DESC');
                  if(images.length > 0){
                  prod.images=images;
                  }else{
                  const images =  await knex('product')
                  .select(knex.raw(`CONCAT('${baseurl}', product_image) as image`))   
                  .where('product_id', prod.product_id);
                  prod.images=images;
                  }

                let app =   await knex('store_products')
                 .join ('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
                 .select('store_products.store_id','store_products.stock','product_varient.varient_id', 'product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity')
                 .where('store_products.store_id', appDetatils.store_id)
                 .where('product_varient.product_id', prod.product_id)
                 .whereNotNull('store_products.price')
                 .where('product_varient.approved',1)

                 //prod.varient = app;
                 const customizedProductData = [];
                 for (let i = 0; i < app.length; i++) {
                   // prod.varient.dummy = 5678;
                    const ProductList = app[i];
                    const currentDate = new Date();
                    const deal = await knex('deal_product')
                    .where('varient_id', ProductList.varient_id)
                    .where('store_id', appDetatils.store_id)
                    .where('deal_product.valid_from', '<=', currentDate)
                    .where('deal_product.valid_to', '>', currentDate)
                    .first();
                  
                    
                    if (deal) {
                      price = deal.deal_price;
                    } else {
                    const sp = await knex('store_products')
                    .where('varient_id', ProductList.varient_id)
                    .where('store_id', appDetatils.store_id)
                    .first();
                    price = sp.price;
                    }

                    if(appDetatils.user_id){ 
                      // Wishlist check 
                       var isFavourite='';
                      var notifyMe='';
                      var cartQty=0;
                       const wishList = await knex('wishlist')
                      .select('*')
                      .where('varient_id',ProductList.varient_id)
                      .where('user_id',user_id);
              
                      isFavourite = wishList.length > 0 ? 'true' : 'false';
               
                      // cart qty check 
                      const CartQtyList = await knex('store_orders')
                      .where('varient_id',ProductList.varient_id)
                      .where('store_approval',user_id)
                      .where('order_cart_id','incart')
                      .whereNull('subscription_flag')
                      .where('store_id',appDetatils.store_id)
                      .first();
                      cartQty = CartQtyList ? CartQtyList.qty : 0;
                      
                      const cnotify_me = await knex('product_notify_me')
                      .where('varient_id', ProductList.varient_id)
                      .where('user_id', user_id)
                      .first();

                      notifyMe = (cnotify_me) ? 'true' : 'false';

                      }else{
                        notifyMe='false';
                        isFavourite='false';
                        cartQty=0;
                      }
                      const baseurl =  process.env.BUNNY_NET_IMAGE;

                      const sub_price = (prod.mrp * prod.percentage) / 100;
                      const finalsubprice =  prod.mrp - sub_price;
                       prod.subscription_price = parseFloat(finalsubprice.toFixed(2));
                       prod.availability =  prod.availability
                       prod.percentage = prod.percentage
                       prod.isAutoRenew = "no"
                
                      const customizedProduct = {
                        stock: ProductList.stock,        
                        varient_id: ProductList.varient_id,
                        product_id: ProductList.product_id,
                        product_name: ProductList.product_name,
                        product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                        thumbnail: baseurl + ProductList.thumbnail,
                        description:ProductList.description,
                        price: price,
                        mrp: ProductList.mrp,
                        unit: ProductList.unit,
                        quantity: ProductList.quantity,
                        type: ProductList.type,
                        //discountper: ProductList.discountper,
                        discountper:0,
                        // avgrating:0,
                        notify_me: notifyMe,
                        isFavourite: isFavourite,
                        cart_qty: cartQty
                        // countrating:0
                        // Add or modify properties as needed
                        };
                    
                      customizedProductData.push(customizedProduct);  
                 }
                 prod.varient =  customizedProductData;
      return prod;
    
    
};

const getcatProduct = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
  const {
    cat_id,
    sub_cat_id: subcatid,
    store_id,
    byname: filter1,
    sort: issort,
    sortprice,
    sortname,
    user_id: rawUserId,
    min_price: minPrice,
    max_price: maxPrice,
    min_discount: minDiscount,
    max_discount: maxDiscount,
    page: pageFilter,
    perpage: perPage
  } = appDetatils;

  const user_id = rawUserId !== "null" ? rawUserId : appDetatils.device_id;
  const minprice = parseFloat(minPrice);
  const maxprice = parseFloat(maxPrice);
  const mindiscount = parseFloat(minDiscount);
  const maxdiscount = parseFloat(maxDiscount);
  const offset = (pageFilter - 1) * perPage;

  // Build base query
  let topsellingsQuery = knex('store_products')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .select(
      'store_products.stock',
      'product_varient.varient_id',
      'product_varient.description',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'store_products.price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      'tbl_country.country_icon',
      'product.percentage',
      'product.availability',
      'product.fcat_id',
      knex.raw('100 - (store_products.price * 100 / store_products.mrp) as discountper'),
      knex.raw('100 - (deal_product.deal_price * 100 / store_products.mrp) as discountper1')
    )
    .where('store_products.store_id', store_id)
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('product.approved', 1)
    .whereNotNull('store_products.price');
    
    

  // Apply category filters
  if (cat_id !== "null") {
    const categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    topsellingsQuery.whereIn('product.cat_id', categoryarray);
  }

  if (subcatid !== "null") {
    topsellingsQuery.where('product.cat_id', subcatid);
  }

  // Apply price and discount filters
  if (minprice && maxprice) {
    topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
  }

  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [mindiscount, maxdiscount, mindiscount, maxdiscount]);
  }

  // Apply sorting
  if (sortprice === 'ltoh') {
    topsellingsQuery.orderBy('store_products.price', 'ASC');
  }

  if (sortprice === 'htol') {
    topsellingsQuery.orderBy('store_products.price', 'DESC');
  }

  if (sortname === 'atoz') {
    topsellingsQuery.orderBy('product.product_name', 'ASC');
  }

  if (sortname === 'ztoa') {
    topsellingsQuery.orderBy('product.product_name', 'DESC');
  }

  // Fetch paginated products
  const productDetails = await topsellingsQuery.offset(offset).limit(perPage);

  // Collect variant IDs for batch queries
  const variantIds = productDetails.map(p => p.varient_id);

  // Fetch related data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id).whereIn('varient_id', variantIds),
    knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
    knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
    knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1)
  ]);

  // Process product details
  const customizedProductData = await Promise.all(productDetails.map(async (product) => {
    const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
    const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
    const cartQty = cartItem ? cartItem.qty : 0;
    const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
    const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false';

    const sub_price = (product.mrp * product.percentage) / 100;
    const finalsubprice = product.mrp - sub_price;
    const subscription_price = parseFloat(finalsubprice.toFixed(2));
    const baseurl = process.env.BUNNY_NET_IMAGE;
    const countryicon = product.country_icon ? baseurl + product.country_icon : null;

    // Determine the price (either from deal or regular price)
    const price = await knex('deal_product')
      .where('varient_id', product.varient_id)
      .where('store_id', store_id)
      .where('deal_product.valid_from', '<=', new Date())
      .where('deal_product.valid_to', '>', new Date())
      .first()
      .then(deal => deal ? deal.deal_price : product.price);
  
    // if (Number.isInteger(price)) {
    //    priceval = price + '.001'
    // }else{
    //    priceval = price
    // }
    // if (Number.isInteger(product.mrp)) {
    //    mrpval = product.mrp + '.001'
    // }else{
    //    mrpval = product.mrp
    // }
    
 const priceval = Number.isInteger(product.price) ? product.price + '.001' : product.price;
 const mrpval = Number.isInteger(product.mrp) ? product.mrp + '.001' : product.mrp;
    
   if(product.fcat_id != null){
        fcatinput = product.fcat_id;
        const resultArray = fcatinput.split(',').map(Number);
        const ftaglist = await knex('feature_categories') 
                  .where('status',1)
                  .where('is_deleted', 0)
                  .whereIn('id', resultArray)
                  .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
        feature_tags  = ftaglist;
      }else{
        feature_tags = [];
      }

    return {
      stock: product.stock,
      varient_id: product.varient_id,
      product_id: product.product_id,
      product_name: product.product_name,
      product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
      thumbnail: product.thumbnail,
      description: product.description,
      price: parseFloat(priceval),
      mrp: parseFloat(mrpval),
      unit: product.unit,
      quantity: product.quantity,
      type: product.type,
      percentage: product.percentage,
      isSubscription,
      subscription_price,
      availability: product.availability,
      discountper: product.discountper || 0,
      avgrating: 0, // Placeholder for ratings
      notify_me: notifyMe,
      isFavourite,
      cart_qty: cartQty,
      countrating: 0, // Placeholder for country ratings
      country_icon: countryicon,
      feature_tags:feature_tags,
      varients: null
    };
  }));

  return customizedProductData;
};

const getfetcatProd = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
  const {
    fcat_id:fcat_id,
    store_id,
    byname: filter1,
    sort: issort,
    sortprice,
    sortname,
    user_id: rawUserId,
    min_price: minPrice,
    max_price: maxPrice,
    min_discount: minDiscount,
    max_discount: maxDiscount,
    page: pageFilter,
    perpage: perPage
  } = appDetatils;

  const user_id = rawUserId !== "null" ? rawUserId : appDetatils.device_id;
  const minprice = parseFloat(minPrice);
  const maxprice = parseFloat(maxPrice);
  const mindiscount = parseFloat(minDiscount);
  const maxdiscount = parseFloat(maxDiscount);
  const offset = (pageFilter - 1) * perPage;

  // Build base query
  let topsellingsQuery = knex('store_products')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .select(
      'store_products.stock',
      'product_varient.varient_id',
      'product_varient.description',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'store_products.price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      'tbl_country.country_icon',
      'product.percentage',
      'product.availability',
      'product.fcat_id',
      knex.raw('100 - (store_products.price * 100 / store_products.mrp) as discountper'),
      knex.raw('100 - (deal_product.deal_price * 100 / store_products.mrp) as discountper1')
    )
    .where('store_products.store_id', store_id)
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('product.approved', 1)
    .where('product.fcat_id', 'like', `%${fcat_id}%`)
    .whereNotNull('store_products.price');

  // Apply category filters
  // if (fcat_id !== "null") {
  //   const categoryarray = await knex('feature_categories').where('parent', cat_id).pluck('cat_id');
  //   topsellingsQuery.whereIn('product.cat_id', categoryarray);
  // }

  // if (subcatid !== "null") {
  //   topsellingsQuery.where('product.cat_id', subcatid);
  // }

  // Apply price and discount filters
  if (minprice && maxprice) {
    topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
  }

  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [mindiscount, maxdiscount, mindiscount, maxdiscount]);
  }

  // Apply sorting
  if (sortprice === 'ltoh') {
    topsellingsQuery.orderBy('store_products.price', 'ASC');
  }

  if (sortprice === 'htol') {
    topsellingsQuery.orderBy('store_products.price', 'DESC');
  }

  if (sortname === 'atoz') {
    topsellingsQuery.orderBy('product.product_name', 'ASC');
  }

  if (sortname === 'ztoa') {
    topsellingsQuery.orderBy('product.product_name', 'DESC');
  }

  // Fetch paginated products
  const productDetails = await topsellingsQuery.offset(offset).limit(perPage);

  // Collect variant IDs for batch queries
  const variantIds = productDetails.map(p => p.varient_id);

  // Fetch related data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id).whereIn('varient_id', variantIds),
    knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
    knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
    knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1)
  ]);

  // Process product details
  const customizedProductData = await Promise.all(productDetails.map(async (product) => {
    const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
    const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
    const cartQty = cartItem ? cartItem.qty : 0;
    const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
    const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false';

    const sub_price = (product.mrp * product.percentage) / 100;
    const finalsubprice = product.mrp - sub_price;
    const subscription_price = parseFloat(finalsubprice.toFixed(2));
    const baseurl = process.env.BUNNY_NET_IMAGE;
    const countryicon = product.country_icon ? baseurl + product.country_icon : null;

    // Determine the price (either from deal or regular price)
    const price = await knex('deal_product')
      .where('varient_id', product.varient_id)
      .where('store_id', store_id)
      .where('deal_product.valid_from', '<=', new Date())
      .where('deal_product.valid_to', '>', new Date())
      .first()
      .then(deal => deal ? deal.deal_price : product.price);
      
      
    if(product.fcat_id != null){
        fcatinput = product.fcat_id;
        const resultArray = fcatinput.split(',').map(Number);
        const ftaglist = await knex('feature_categories') 
                  .where('status',1)
                  .where('is_deleted', 0)
                  .whereIn('id', resultArray)
                  .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
        feature_tags  = ftaglist;
    }else{
        feature_tags = [];
    }
      
     

    return {
      stock: product.stock,
      varient_id: product.varient_id,
      product_id: product.product_id,
      product_name: product.product_name,
      product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
      thumbnail: product.thumbnail,
      description: product.description,
      price: price,
      mrp: product.mrp,
      unit: product.unit,
      quantity: product.quantity,
      type: product.type,
      percentage: product.percentage,
      isSubscription,
      subscription_price,
      availability: product.availability,
      discountper: product.discountper || 0,
      avgrating: 0, // Placeholder for ratings
      notify_me: notifyMe,
      isFavourite,
      cart_qty: cartQty,
      countrating: 0, // Placeholder for country ratings
      country_icon: countryicon,
      feature_tags:feature_tags,
      varients: null
    };
  }));

  return customizedProductData;
};

 const getrecentSelling = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const storeId = store_id;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Fetch products in bulk
  const productDetails = await knex('store_products')
      .select(
          'store_products.store_id',
          'store_products.stock',
          'product_varient.varient_id',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          'product.fcat_id',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .where('store_products.store_id', storeId)
      .where('product.hide', 0)
      .where('product.is_delete', 0)
      .whereNotNull('store_products.price')
      .orderBy('store_products.p_id', 'asc')
      .limit(8);

  const productVarientIds = productDetails.map(product => product.varient_id);

  // Fetch user-related data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
      knex('wishlist').whereIn('varient_id', productVarientIds).where('user_id', user_id),
      knex('store_orders')
          .whereIn('varient_id', productVarientIds)
          .where('store_approval', user_id)
          .where('order_cart_id', 'incart')
          .whereNull('subscription_flag')
          .where('store_id', storeId),
      knex('product_notify_me').whereIn('varient_id', productVarientIds).where('user_id', user_id),
      knex('store_orders')
          .select('store_orders.percentage', 'store_orders.varient_id')
          .whereIn('store_orders.varient_id', productVarientIds)
          .where('store_approval', user_id)
          .where('store_orders.subscription_flag', 1)
          .where('store_orders.order_cart_id', "incart")
  ]);

  // Mapping the fetched data to make it easy to access
  const wishlistMap = wishList.reduce((acc, item) => ({ ...acc, [item.varient_id]: true }), {});
  const cartMap = cartItems.reduce((acc, item) => ({ ...acc, [item.varient_id]: item.qty }), {});
  const notifyMeMap = notifyMeList.reduce((acc, item) => ({ ...acc, [item.varient_id]: true }), {});
  const subscriptionMap = subscriptionProducts.reduce((acc, item) => ({ ...acc, [item.varient_id]: item.percentage }), {});

  // Build final product data
  //const customizedProductData = productDetails.map(product => {
  const customizedProductData = await Promise.all(productDetails.map(async product => {
      let featureTags = [];
      if (product.fcat_id) {
        const resultArray = product.fcat_id.split(',').map(Number);
        featureTags = await knex('feature_categories')
          .whereIn('id', resultArray)
          .where('status',1)
          .where('is_deleted', 0)
          .select('id', knex.raw(`CONCAT('${baseurl}', image) as image`));
      }
      const isFavourite = wishlistMap[product.varient_id] ? 'true' : 'false';
      const cartQty = cartMap[product.varient_id] || 0;
      const notifyMe = notifyMeMap[product.varient_id] ? 'true' : 'false';
      const isSubscription = subscriptionMap[product.varient_id] ? 'true' : 'false';

      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
     
      if (Number.isInteger(product.price)) {
      priceval = product.price + '.001'
      }else{
      priceval = product.price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
          store_id: product.store_id,
          stock: product.stock,
          varient_id: product.varient_id,
          product_id: product.product_id,
          product_name: product.product_name,
          product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
          thumbnail: baseurl + product.thumbnail,
          price: parseFloat(priceval),
          mrp: parseFloat(mrpval),
          unit: product.unit,
          quantity: product.quantity,
          type: product.type,
          discountper: 0,  // Modify if needed
          country_icon: product.country_icon ? baseurl + product.country_icon : null,
          cart_qty: cartQty,
          avgrating: 0,  // Placeholder for average rating
          notify_me: notifyMe,
          percentage: product.percentage,
          isSubscription: isSubscription,
          subscription_price: subscription_price,
          availability: product.availability,
          isFavourite: isFavourite,
          feature_tags:featureTags
      };
  }));

  return customizedProductData;
};

const gettopSellingold = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const pageFilter = appDetatils.page;
  const perPage = appDetatils.perpage;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  let categoryList = await knex('categories').where('parent', 121).pluck('cat_id');

  // Fetch all products in one go
  const productDetail = await knex('store_products')
      .select(
          'store_products.*',
          knex.raw(`CONCAT('${baseurl}', product_image) as product_image`),
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          'tbl_country.country_icon',
          'product_varient.unit as prdunit',
          'product_varient.varient_id',
          'product_varient.quantity',
          'product.product_id',
          'product.product_name',
          'product.thumbnail',
          'product.type',
          'product.percentage',
          'product.availability',
          'product_varient.description',
          'product_varient.varient_image',
          'product_varient.ean',
          'product_varient.approved',
          'product.cat_id',
          'product.brand_id',
          'product.hide',
          'product.added_by'
      )
      .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .where('store_products.store_id', store_id)
      .whereNotNull('store_products.price')
      .where('product.hide', 0)
      .whereIn('product.cat_id', categoryList)
      .where('product.is_delete', 0)
      .where('product.approved', 1)
      .limit(8);

  // Extract variant IDs for bulk queries
  const variantIds = productDetail.map(product => product.varient_id);

  // Batch fetch wishlist, cart, notify me, and subscription data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts, deals] = await Promise.all([
      knex('wishlist').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
      knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1).where('order_cart_id', 'incart'),
      knex('deal_product').whereIn('varient_id', variantIds).where('store_id', store_id).where('deal_product.valid_from', '<=', new Date()).where('deal_product.valid_to', '>', new Date())
  ]);

  // Preprocess deal prices
  const dealMap = {};
  deals.forEach(deal => {
      dealMap[deal.varient_id] = deal.deal_price;
  });

  // Preprocess subscription data
  const subscriptionMap = {};
  subscriptionProducts.forEach(sub => {
      subscriptionMap[sub.varient_id] = true;
  });

  // Preprocess wishlist data
  const wishListMap = {};
  wishList.forEach(item => {
      wishListMap[item.varient_id] = true;
  });

  // Preprocess cart items
  const cartMap = {};
  cartItems.forEach(item => {
      cartMap[item.varient_id] = item.qty;
  });

  // Preprocess notify me data
  const notifyMeMap = {};
  notifyMeList.forEach(item => {
      notifyMeMap[item.varient_id] = true;
  });

  // Process products and construct response
  const customizedProductData = productDetail.map(product => {
      const isFavourite = wishListMap[product.varient_id] ? 'true' : 'false';
      const cartQty = cartMap[product.varient_id] || 0;
      const notifyMe = notifyMeMap[product.varient_id] ? 'true' : 'false';
      const isSubscription = subscriptionMap[product.varient_id] ? 'true' : 'false';
      const dealPrice = dealMap[product.varient_id];
      const price = dealPrice || product.price;
      
      const sub_price = (product.mrp * product.percentage) / 100;
      const subscription_price = parseFloat((product.mrp - sub_price).toFixed(2));

      const country_icon = product.country_icon ? baseurl + product.country_icon : null;

      if (Number.isInteger(price)) {
      priceval = price + '.001'
      }else{
      priceval = price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
          p_id: product.p_id,
          varient_id: product.varient_id,
          stock: product.stock,
          store_id: product.store_id,
          price: parseFloat(priceval),
          mrp: parseFloat(mrpval),
          min_ord_qty: product.min_ord_qty,
          max_ord_qty: product.max_ord_qty,
          buyingprice:product.buyingprice,
          product_code: product.product_code,
          partner_id: product.partner_id,
          product_id: product.product_id,
          quantity: product.quantity,
          unit: product.prdunit,
          description: product.description,
          varient_image: product.varient_image,
          ean: product.ean,
          approved: product.approved,
          added_by:product.added_by,
          cat_id: product.cat_id,
          brand_id: product.brand_id,
          product_name: product.product_name,
          product_image: product.product_image+"?width=200&height=200&quality=100",
          type: product.type,
          hide:product.hide,
          percentage: product.percentage,
          isSubscription: isSubscription,
          subscription_price: subscription_price,
          availability: product.availability,
          discountper: product.discountper || 0,
          country_icon: country_icon,
          avgrating: 0, // Placeholder for ratings
          notify_me: notifyMe,
          isFavourite: isFavourite,
          cart_qty: cartQty,
          countrating: 0
      };
  });

  return customizedProductData;
};

const gettopSelling = async (appDetails) => {
  try {
    const { store_id, is_subscription } = appDetails;
    const user_id = appDetails.user_id !== "null" ? appDetails.user_id : appDetails.device_id;
    const baseurl = process.env.BUNNY_NET_IMAGE;

    // Fetch category list
   // const categoryList = await knex('categories').where('parent', 121).pluck('cat_id');
     let categoryList = await knex('categories').where('parent', 1).pluck('cat_id');
    // Fetch product details
    // const productDetail = await knex('store_products')
    //   .select(
    //     'store_products.*',
    //     knex.raw(`CONCAT('${baseurl}', product_image) as product_image`),
    //     knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
    //     'tbl_country.country_icon',
    //     'product_varient.unit as prdunit',
    //     'product_varient.varient_id',
    //     'product_varient.quantity',
    //     'product.product_id',
    //     'product.product_name',
    //     'product.thumbnail',
    //     'product.type',
    //     'product.percentage',
    //     'product.availability',
    //     'product_varient.description',
    //     'product_varient.varient_image',
    //     'product_varient.ean',
    //     'product_varient.approved',
    //     'product.cat_id',
    //     'product.brand_id',
    //     'product.hide',
    //     'product.added_by',
    //     'product.fcat_id'
    //   )
    //   .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
    //   .innerJoin('product', 'product_varient.product_id', 'product.product_id')
    //   .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    //   .where('store_products.store_id', store_id)
    //   .whereNotNull('store_products.price')
    //   .where('product.hide', 0)
    //   .whereIn('product.cat_id', categoryList)
    //   .where('product.is_delete', 0)
    //   .where('product.approved', 1)
    //   .limit(8);
    
    
    const today = new Date(); // current date
        const oneYearAgo = new Date();
        oneYearAgo.setFullYear(today.getFullYear() - 1);
        // Format to 'YYYY-MM-DD'
        const oneYearAgoDate = oneYearAgo.toISOString().slice(0, 10);

        const productDetail = await knex('subscription_order as sub')
        .join('store_orders as so', 'sub.store_order_id', 'so.store_order_id')
        .join('store_products as sp', 'sp.varient_id', 'so.varient_id')
        .join('product_varient as pv', 'pv.varient_id', 'so.varient_id')
        .join('orders as or', 'or.cart_id', 'so.order_cart_id')
        .join('product as p', 'pv.product_id', 'p.product_id')
        .leftJoin('tbl_country as c', 'c.id', '=', 'p.country_id')
        .join('categories as cat', 'cat.cat_id', 'p.cat_id')
        .join('brands as brand', 'brand.cat_id', 'p.brand_id')
        .select(
        'sp.*',  
        knex.raw(`CONCAT('${baseurl}', product_image) as product_image`),
        knex.raw('100-((sp.price*100)/sp.mrp) as discountper'),
        'c.country_icon',  
        'pv.unit as prdunit',
        'pv.varient_id',
        'pv.quantity',
        'p.product_id',
        'cat.cat_id',
        'cat.parent',
        'p.product_name',
        'p.thumbnail',
        'p.type',
        'p.percentage',
        'p.availability',
        knex.raw('SUM(so.qty) as total_quantity'),
        'pv.description',
        'pv.varient_image',
        'pv.ean',
        'p.approved',
        'p.cat_id',
        'p.brand_id',
        'p.hide',
        'p.added_by',
        'p.fcat_id'
        )
      .whereNotIn('sub.order_status', ['Pause', 'Cancelled'])
      .where('or.order_date', '>=', oneYearAgoDate) // make sure `oneYearAgo` is a valid Date object or formatted string
      .groupBy('p.product_name', 'pv.varient_id')
      .orderBy('total_quantity', 'desc')
      .limit(10);

    const variantIds = productDetail.map(product => product.varient_id);

    // Fetch associated data in parallel
    const [wishList, cartItems, notifyMeList, subscriptionProducts, deals] = await Promise.all([
      knex('wishlist').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders')
        .whereIn('varient_id', variantIds)
        .where('store_approval', user_id)
        .where('order_cart_id', 'incart')
        .whereNull('subscription_flag')
        .where('store_id', store_id),
      knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders')
        .select('varient_id')
        .whereIn('varient_id', variantIds)
        .where('store_approval', user_id)
        .where('subscription_flag', 1)
        .where('order_cart_id', 'incart'),
      knex('deal_product')
        .whereIn('varient_id', variantIds)
        .where('store_id', store_id)
        .where('deal_product.valid_from', '<=', new Date())
        .where('deal_product.valid_to', '>', new Date())
    ]);

    const dealMap = Object.fromEntries(deals.map(deal => [deal.varient_id, deal.deal_price]));
    const subscriptionMap = Object.fromEntries(subscriptionProducts.map(sub => [sub.varient_id, true]));
    const wishListMap = Object.fromEntries(wishList.map(item => [item.varient_id, true]));
    const cartMap = Object.fromEntries(cartItems.map(item => [item.varient_id, item.qty]));
    const notifyMeMap = Object.fromEntries(notifyMeList.map(item => [item.varient_id, true]));

    // Process product details with asynchronous logic for feature tags
    const customizedProductData = await Promise.all(productDetail.map(async product => {
      let featureTags = [];
      if (product.fcat_id) {
        const resultArray = product.fcat_id.split(',').map(Number);
        featureTags = await knex('feature_categories')
          .whereIn('id', resultArray)
          .where('status',1)
          .where('is_deleted', 0)
          .select('id', knex.raw(`CONCAT('${baseurl}', image) as image`));
      }

      const price = dealMap[product.varient_id] || product.price;
      const subscriptionPrice = parseFloat((product.mrp - (product.mrp * product.percentage) / 100).toFixed(2));

      return {
        p_id: product.p_id,
        varient_id: product.varient_id,
        stock: product.stock,
        store_id: product.store_id,
        price: parseFloat(price),
        mrp: parseFloat(product.mrp),
        min_ord_qty: product.min_ord_qty,
        max_ord_qty: product.max_ord_qty,
        buyingprice: product.buyingprice,
        product_code: product.product_code,
        partner_id: product.partner_id,
        product_id: product.product_id,
        quantity: product.quantity,
        unit: product.prdunit,
        description: product.description,
        varient_image: product.varient_image,
        ean: product.ean,
        approved: product.approved,
        added_by: product.added_by,
        cat_id: product.cat_id,
        brand_id: product.brand_id,
        product_name: product.product_name,
        product_image: `${product.product_image}?width=200&height=200&quality=100`,
        type: product.type,
        hide: product.hide,
        percentage: product.percentage,
        isSubscription: subscriptionMap[product.varient_id] ? 'true' : 'false',
        subscription_price: subscriptionPrice,
        availability: product.availability,
        discountper: product.discountper || 0,
        country_icon: product.country_icon ? `${baseurl}${product.country_icon}` : null,
        avgrating: 0,
        notify_me: notifyMeMap[product.varient_id] ? 'true' : 'false',
        isFavourite: wishListMap[product.varient_id] ? 'true' : 'false',
        cart_qty: cartMap[product.varient_id] || 0,
        countrating: 0,
        feature_tags: featureTags
      };
    }));

    return customizedProductData;
  } catch (error) {
    console.error("Error fetching top-selling products:", error);
    throw error;
  }
};

const getsubscriptonDetails = async (appDetatils) => {
   const {store_id,is_subscription} = appDetatils;
   
   
   if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
   const subdetails = await knex('users')
   .where('id',user_id)
   .where('noti_popup',1);

   if(subdetails.length > 0)
   {
    return subscripton_details = {
    'is_subscription':1,
    'message':''
    };
   }else
   {
    return subscripton_details = {
      'is_subscription':1,
      'message':''
      };
   }

};

const getadditionalCategory = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Fetch all categories
  const results = await knex('additional_category').whereNot('id', 12).where('status',1).orderBy('main_order', 'asc');
  
  if (results.length === 0) {
    return [];
  }

  // Prepare a list to return
  const customizedData = [];

  // Fetch all wishlist, cart, notify me, and subscription data for user in one go
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id),
    knex('store_orders').where('store_approval', user_id).where('store_id', store_id).where('order_cart_id', 'incart').whereNull('subscription_flag'),
    knex('product_notify_me').where('user_id', user_id),
    knex('store_orders').select('varient_id').where('store_approval', user_id).where('subscription_flag', 1)
  ]);

  // Process each category
  for (const item of results) {
    const categoryProductIds = item.product_id.split(',');
    
    // Fetch product details for current category
    const productDetail = await knex('product')
      .select(
        'store_products.store_id',
        'store_products.stock',
        'product_varient.varient_image',
        'product_varient.quantity',
        'product_varient.unit',
        'store_products.price',
        'store_products.mrp',
        'product_varient.description',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.varient_id',
        'product.product_id',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        'product.fcat_id',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .leftJoin('add_catproduct_order', 'add_catproduct_order.product_id', '=', 'product.product_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .whereIn('product.product_id', categoryProductIds)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0)
      .orderBy('add_catproduct_order.orders','asc');

    // Deduplicate products
    const productDetails = productDetail.filter((product, index, self) => 
      index === self.findIndex((p) => p.product_id === product.product_id)
    ).slice(0, 6);

    // Process product details and add additional info (wishlist, cart qty, subscription, etc.)
    //const customizedProductData = productDetails.map(product => {
    const customizedProductData = await Promise.all(productDetails.map(async product => {
        let featureTags = [];
        if (product.fcat_id) {
          const resultArray = product.fcat_id.split(',').map(Number);
          featureTags = await knex('feature_categories')
            .whereIn('id', resultArray)
            .where('status',1)
            .where('is_deleted', 0)
            .select('id', knex.raw(`CONCAT('${baseurl}', image) as image`));
        }
      const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
      const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
      const cartQty = cartItem ? cartItem.qty : 0;
      const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
      const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false'; // Check if it's in subscription

      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
      if (Number.isInteger(product.price)) {
      priceval = product.price + '.001'
      }else{
      priceval = product.price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
        store_id: product.store_id,
        stock: product.stock,
        varient_id: product.varient_id,
        product_id: product.product_id,
        product_name: product.product_name,
        product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
        thumbnail: product.thumbnail,
        price: parseFloat(priceval),
        mrp: parseFloat(mrpval),
        unit: product.unit,
        quantity: product.quantity,
        type: product.type,
        discountper: product.discountper || 0,
        country_icon: product.country_icon ? baseurl + product.country_icon : null,
        cart_qty: cartQty,
        avgrating: 0, // Placeholder for ratings
        notify_me: notifyMe,
        isFavourite: isFavourite,
        percentage: product.percentage,
        isSubscription: isSubscription,
        subscription_price: subscription_price,
        availability: product.availability,
        feature_tags:featureTags
      };
    }));

    // Add category with its specific product details
    customizedData.push({
      id: item.id,
      title: item.title,
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      product_details: customizedProductData
    });
  }

  return customizedData;
};

const getcategoryList =async (appDetatils) => {
    const {store_id} = appDetatils;
    const storeId = store_id;
    
    const cats = await knex('categories')
  .join('categories as cat', 'categories.cat_id', '=', 'cat.parent')
  .join('product', 'cat.cat_id', '=', 'product.cat_id')
  .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
  .join('store_products', 'product_varient.varient_id', '=', 'store_products.varient_id')
  .select(
    'categories.order_list',
    'categories.title',
    'categories.cat_id',
    'categories.image',
    'store_products.store_id',
    'categories.description',
    knex.raw('MIN(store_products.price) as stfrom'),
    knex.raw('COUNT(cat.cat_id) as subcat_count')
  )
  .groupBy(
    'categories.order_list',
    'categories.title',
    'categories.cat_id',
    'categories.image',
    'store_products.store_id',
    'categories.description'
  )
  .where('categories.level', 0)
  .where('categories.is_delete', 0)
  .where('store_products.store_id', storeId)
  .orderBy('categories.cat_id', 'asc');
  const catss = cats.filter((categories, index, self) => {
    return index === self.findIndex((p) => p.cat_id === categories.cat_id);
    });
    const customizedCategoryData = [];
      for (let j = 0; j < catss.length; j++) {
        const cats = catss[j];

        const subCategory = await knex('categories')
        .join('product', 'categories.cat_id', '=', 'product.cat_id')
        .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
        .join('store_products', 'product_varient.varient_id', '=', 'store_products.varient_id')
        .select(
        'categories.title',
        'categories.cat_id',
        'categories.image',
        'store_products.store_id',
        'categories.description',
        knex.raw('MIN(store_products.price) as stfrom')
        )
        .groupBy(
        'categories.title',
        'categories.cat_id',
        'categories.image',
        'store_products.store_id',
        'categories.description'
        )
        .where('categories.parent', cats.cat_id)
        .where('categories.level', 1)
        .where('categories.is_delete', 0)
        .orderBy('categories.order_list', 'asc');
        
        const subCategorys = subCategory.filter((categories, index, self) => {
          return index === self.findIndex((p) => p.cat_id === categories.cat_id);
          });
        const baseurl =  process.env.BUNNY_NET_IMAGE;
        
        const customizedcategory = {
          order_list: cats.order_list,
          title: cats.title,
          cat_id: cats.cat_id,
          image: baseurl + cats.image,
          store_id: cats.store_id,
          description: cats.description,
          stfrom: cats.stfrom,
          subcat_count: cats.subcat_count,
          subcategory:subCategorys
          // Add or modify properties as needed
          };
          customizedCategoryData.push(customizedcategory);
      }
  return customizedCategoryData;
};
 
const getsubcategoryList = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');

  const storeId = appDetatils.store_id;
  const catId = appDetatils.cat_id;
  const sortprice = appDetatils.sortprice;
  const sortname = appDetatils.sortname;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Define sorting order for price and name
  const priceOrder = sortprice === 'asc' ? 'asc' : 'desc';
  const nameOrder = sortname === 'asc' ? 'asc' : 'desc';

  // Fetch categories with pagination
  const page = appDetatils.page || 1;
  const perPage = appDetatils.perpage || 10;
  const offset = (page - 1) * perPage;

  const cats = await knex('categories')
    .select(
      'product.fcat_id',
      'categories.status',
      'categories.order_list',
      'categories.order',
      'categories.title',
      'categories.cat_id',
      knex.raw(`CONCAT('${baseurl}', categories.image) as image`),
       knex.raw(`CONCAT('${baseurl}', categories.cat_bannerimage) as cat_bannerimage`),
      'categories.description'
    )
    .leftJoin('product', 'categories.cat_id', 'product.cat_id')
    .leftJoin('product_varient', 'product.product_id', 'product_varient.product_id')
    .leftJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
    .where('store_products.store_id', storeId)
    .where('categories.parent', catId)
    .where('categories.status', 1)
    .groupBy('categories.status', 'categories.order_list', 'categories.order', 'categories.title', 'categories.cat_id', 'categories.image', 'categories.description')
    .orderBy('categories.order', 'asc');
  if (cats.length === 0) {
    throw new Error('Products not found');
  }

  return cats.map(cat => ({
    status: cat.status,
    order_list: cat.order_list,
    order: cat.order,
    title: cat.title,
    cat_id: cat.cat_id,
    image: cat.image,
    banner:cat.cat_bannerimage,
    description: cat.description,
  }));
};


const getoccasionalCategory = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const currentDate = new Date().toISOString().split('T')[0];
  
  const todayDay = moment().format('ddd').toLowerCase();
  // Fetch all categories
//   const results = await knex('occasional_category')
//   .orderBy('main_order', 'asc')
//   .where('hide', 0)
//   .where('from_date', '<=', currentDate)
//   .andWhere('to_date', '>=', currentDate);
  
  const results = await knex('occasional_category')
  .orderBy('main_order', 'asc')
  .where('hide', 1)
  .where('from_date', '<=', currentDate)
  .andWhere('to_date', '>=', currentDate)
  .andWhere((builder) => {
      builder.whereRaw(`FIND_IN_SET(?, available_days)`, [todayDay])
             .orWhereRaw(`FIND_IN_SET(?, available_days)`, ['all']);
  });
  
  if (results.length === 0) {
    return [];
  }
  // Prepare a list to return
  const customizedData = [];
  // Fetch all wishlist, cart, notify me, and subscription data for user in one go
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id),
    knex('store_orders').where('store_approval', user_id).where('store_id', store_id).where('order_cart_id', 'incart').whereNull('subscription_flag'),
    knex('product_notify_me').where('user_id', user_id),
    knex('store_orders').select('varient_id').where('store_approval', user_id).where('subscription_flag', 1)
  ]);
  // Process each category
  for (const item of results) {
  //  const categoryProductIds = item.product_id.split(',');
    
    
   let categoryProductIds = [];
    
    if(item.product_id && item.subcat_id && item.cat_id){
     productIds = item.product_id.split(',');  
     categoryProductIds = productIds.map(Number);  
    }

    if((item.product_id == '' || item.product_id == null)  && item.subcat_id  && item.cat_id){
      const subcategories = item.subcat_id.split(',');
      const productIds = await knex('product')
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .whereIn('product.cat_id', subcategories)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0).pluck('product.product_id');

      categoryProductIds = productIds;
    }

    if((item.product_id == '' || item.product_id == null) && (item.subcat_id == '' || item.subcat_id == null) && item.cat_id){
      const parent_cat_id = item.cat_id.split(',');
      const subcategories = await knex('categories')
      .whereIn('parent', parent_cat_id)
      .where('status',1).pluck('cat_id');
      // console.log('subcategories',subcategories);

      const productIds = await knex('product')
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .whereIn('product.cat_id', subcategories)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0).pluck('product.product_id');

      categoryProductIds = productIds;
    }

    
    
    
    
    
    
    
    const catid = item.cat_id;
     const subcatid = item.subcatid;
    // Fetch product details for current category
    const productDetail = await knex('product')
      .select(
        'store_products.store_id',
        'store_products.stock',
        'product_varient.varient_image',
        'product_varient.quantity',
        'product_varient.unit',
        'store_products.price',
        'store_products.mrp',
        'product_varient.description',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.varient_id',
        'product.product_id',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        'product.fcat_id',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .leftJoin('add_occproduct_order', 'add_occproduct_order.product_id', '=', 'product.product_id')
      .where('store_products.stock','>',0)
      .whereIn('product.product_id', categoryProductIds)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0)
    //   .modify(function(queryBuilder) {
    //         if (subcatid) {
    //           queryBuilder.andWhere('product.cat_id', subcatid);
    //         }
    //       })
      .orderBy('add_occproduct_order.orders', 'asc');
    // Deduplicate products
    const productDetails = productDetail.filter((product, index, self) =>
      index === self.findIndex((p) => p.product_id === product.product_id)
    ).slice(0, 6);
    // Process product details and add additional info (wishlist, cart qty, subscription, etc.)
    //const customizedProductData = productDetails.map(product => {
    const customizedProductData = await Promise.all(productDetails.map(async product => {
        let featureTags = [];
        if (product.fcat_id) {
          const resultArray = product.fcat_id.split(',').map(Number);
          featureTags = await knex('feature_categories')
            .whereIn('id', resultArray)
            .where('status',1)
            .where('is_deleted', 0)
            .select('id', knex.raw(`CONCAT('${baseurl}', image) as image`));
        }
      const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
      const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
      const cartQty = cartItem ? cartItem.qty : 0;
      const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
      const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false'; // Check if it's in subscription
      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
      return {
        store_id: product.store_id,
        stock: product.stock,
        varient_id: product.varient_id,
        product_id: product.product_id,
        product_name: product.product_name,
        product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
        thumbnail: product.thumbnail,
        price: product.price,
        mrp: product.mrp,
        unit: product.unit,
        quantity: product.quantity,
        type: product.type,
        discountper: product.discountper || 0,
        country_icon: product.country_icon ? baseurl + product.country_icon : null,
        cart_qty: cartQty,
        avgrating: 0, // Placeholder for ratings
        notify_me: notifyMe,
        isFavourite: isFavourite,
        percentage: product.percentage,
        isSubscription: isSubscription,
        subscription_price: subscription_price,
        availability: product.availability,
        feature_tags:featureTags
      };
    }));
    // Add category with its specific product details
    customizedData.push({
      id: item.id,
      title: item.title.toUpperCase(),
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      from_date :item.from_date,
      to_date:item.to_date,
      available_days:item.available_days,
      product_details: customizedProductData
    });
  }
  return customizedData;
};

const getactivesubord = async (appDetails) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const { user_id, store_id } = appDetails;
  const today = new Date();

  // Fetch ongoing subscriptions
  const ongoing = await knex('subscription_order')
    .select(
      knex.raw('SUM(orders.total_products_mrp) as totalProductsMrp'),
      'orders.group_id',
      'orders.cart_id',
      knex.raw('DATE_FORMAT(subscription_order.delivery_date, "%Y-%m-%d") as delivery_date'),
      knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),
      'orders.total_delivery',
      'store_orders.price',
      'store_orders.store_order_id',
      'store_orders.product_name',
      'store_orders.total_mrp',
      'store_orders.repeat_orders',
      'subscription_order.order_status',
      'orders.si_order',
      'orders.si_sub_ref_no',
      'orders.pastorecentrder'
    )
    .join('store_orders', 'subscription_order.cart_id', '=', 'store_orders.order_cart_id')
    .join('orders', 'orders.cart_id', '=', 'subscription_order.cart_id')
    .whereNot('order_cart_id', 'incart')
    .where('orders.user_id', user_id)
    .where('orders.store_id', store_id)
    .where('subscription_order.order_status', 'Pending')
    .where('orders.is_subscription', 1)
    .where('subscription_order.delivery_date', '>', today)
    .whereNotNull('orders.payment_method')
    .groupBy('orders.group_id')
    .orderBy('orders.order_id', 'DESC');

  // Extract cart_ids for batch processing
  const cartIds = ongoing.map(o => o.cart_id);
  const storeOrderIds = ongoing.map(o => o.store_order_id);

  // Fetch subscription orders, order details, and delivery ratings in parallel
  const [subscriptionOrders, orderDetails, deliveryRatings, storeOrders] = await Promise.all([
    knex('subscription_order')
      .whereIn('cart_id', cartIds)
      .whereIn('store_order_id', storeOrderIds)
      .where('order_status', 'Pending')
      .orderBy('id', 'DESC')
      .select('cart_id', 'store_order_id', 'subscription_id', 'delivery_date'),
    knex('orders')
      .whereIn('cart_id', cartIds)
      .select('cart_id', 'total_products_mrp', 'pastorecentrder'),
    knex('delivery_rating')
      .where('user_id', user_id)
      .whereIn('cart_id', cartIds)
      .select('cart_id', 'description', 'rating'),
    knex('store_orders')
      .whereIn('order_cart_id', cartIds)
      .select(
        'order_cart_id',
        'product_name',
        'qty',
        knex.raw(`CONCAT(?, varient_image, ?) as varient_image`, [baseurl, '?width=100&height=100&quality=100'])
      )
      
  ]);

  // Create a map for delivery ratings
  const deliveryRatingsMap = Object.fromEntries(
    deliveryRatings.map(rating => [rating.cart_id, { rating: rating.rating, description: rating.description }])
  );

  // Create a map for store orders
const storeOrderMap = storeOrders.reduce((acc, order) => {
  if (!acc[order.order_cart_id]) {
    acc[order.order_cart_id] = [];
  }
  acc[order.order_cart_id].push({
    order_cart_id: order.order_cart_id,
    product_name: `${order.product_name} X ${order.qty}`,
    varient_image: order.varient_image
  });
  return acc;
}, {});

// Process ongoing subscriptions
const customizedProductData = await Promise.all(
  ongoing.map(async (product) => {
    const subscriptionOrder = subscriptionOrders.find(o => o.cart_id === product.cart_id && o.store_order_id === product.store_order_id);
    const orderDetail = orderDetails.find(o => o.cart_id === product.cart_id) || {};
    const ratingData = deliveryRatingsMap[product.cart_id] || { rating: null, description: null };

    // Ensure totalProductsMrp has a valid value
    const totalProductsMrp = product.pastorecentrder === 'old' ? (orderDetail.total_products_mrp || 0) : (product.totalProductsMrp || 0);

    // Determine order status
    const deliveryDate = new Date(product.delivery_date);
    let orderStatus = deliveryDate > today ? 'Pending' : 'Completed';
    if (product.order_status === 'Cancelled') orderStatus = 'Cancelled';

    // Handle repeat_orders safely
    const repeatOrders = product.repeat_orders ? product.repeat_orders.split(',').map(item => item.trim()) : [];
    const totalDeliveryWeek = repeatOrders.length * (product.total_delivery || 1);

    // Fetch product details asynchronously
    const productDetailsResult = await knex('orders')
      .select(knex.raw(`GROUP_CONCAT(CONCAT(store_orders.product_name, ' X ', store_orders.qty)) as product_details`))
      .join('store_orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
      .where('orders.cart_id', product.cart_id)
      .first();

    // Get the list of products for the current order's cart_ids
    const orderCartIds = ongoing
      .filter(data => data.group_id === product.group_id)
      .map(data => data.cart_id);

    const prodList = orderCartIds.flatMap(cart_id => storeOrderMap[cart_id] || []); // Ensure it's an array of objects
    
    const result = await knex('orders')
    .where('group_id', product.group_id)
    .sum('total_products_mrp as amount');
    
    const Cartamount = result[0].amount;

    return {
      cart_id: product.cart_id,
      group_id: product.group_id,
      order_date: product.order_date,
      total_mrp: parseFloat(Cartamount).toFixed(2),
      subscription_id: subscriptionOrder ? subscriptionOrder.subscription_id : '',
      order_status: orderStatus,
      si_order: product.si_order,
      si_sub_ref_no: product.si_sub_ref_no,
      drating: ratingData.rating,
      dreview: ratingData.description,
      productname: productDetailsResult ? productDetailsResult.product_details : '',
      prodList: prodList // Now contains objects with order_cart_id, product_name, and varient_image
    };
  })
);

return customizedProductData;
};

module.exports = {
  getBanner,
  getTopCat,
  getWhatsNew,
  getdealProduct,
  getsecondBanner,
  getrecentSelling,
  gettopSelling,
  getsubscriptonDetails,
  getadditionalCategory,
  getcategoryList,
  getsubcategoryList,
  prodDetails,
  similarProds,
  getcatProduct,
  getorderList,
  getBrand,
  getBrandlist,
  specialOfferBanner,
  sneakyOfferBanner,
  popupBanner,
  getaboutData,
  gettermsData,
  getoccasionalCategory,
  getfeaturecat,
  getfetcatProd,
  getactivesubord,
  trailpackimagedata
  };