const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library


const notificationlist = async (appDetails) => {
  const user = appDetails.user_id;

  // Fetch notifications from the database, ordered by created_at in DESCENDING order
  const notifybys = await knex('user_notification')
    .where('user_id', user)
    .orderBy('created_at', 'DESC'); // Ensure latest notifications come first

  const baseurl = process.env.BUNNY_NET_IMAGE;
  let monthlyData = {};

  if (notifybys.length > 0) {
    notifybys.forEach((ProductList) => {
      const createdAt = new Date(ProductList.created_at);
      const year = createdAt.getFullYear();
      const month = createdAt.toLocaleString('default', { month: 'short' }); // Get short month name (Jan, Feb, etc.)
      const monthYearKey = `${month} - ${year}`; // Format as "Jan - 2024"

      const imageval =
        !ProductList.image || ProductList.image.trim() === '' || 
        ProductList.image === "/N/A" || ProductList.image === "N/A"
          ? null
          : baseurl + ProductList.image;

      const customizedProduct = {
        noti_id: ProductList.noti_id,
        user_id: user,
        noti_title: ProductList.noti_title || "Quickart",
        image: imageval,
        noti_message: ProductList.noti_message,
        read_by_user: ProductList.read_by_user,
        created_at: ProductList.created_at,
      };

      // Grouping data by "Month - Year"
      if (!monthlyData[monthYearKey]) {
        monthlyData[monthYearKey] = [];
      }
      monthlyData[monthYearKey].push(customizedProduct);
    });

    // Sorting months in descending order (latest first)
    const sortedMonthlyData = Object.entries(monthlyData)
      .sort(([a], [b]) => {
        const [monthA, yearA] = a.split(" - ");
        const [monthB, yearB] = b.split(" - ");
        
        const dateA = new Date(`${monthA} 1, ${yearA}`);
        const dateB = new Date(`${monthB} 1, ${yearB}`);

        return dateB - dateA; // Sort descending
      })
      .map(([title, notification_listing]) => ({
        title,
        notification_listing,
      }));

    return { data: sortedMonthlyData };
  } else {
    return { data: [] }; // Return an empty array if no notifications are found
  }
};



const notificationlistold = async (appDetatils) => {
// return 678
//  const userLat = appDetatils.userLat
const user = appDetatils.user_id;
const currentDate = new Date();
notifybys = await knex('user_notification')
.where('user_id',user)
.orderBy('noti_id','DESC')
const customizedProductData = [];
if(notifybys.length > 0){

for (let i = 0; i < notifybys.length; i++) {

const ProductList = notifybys[i];
const baseurl =  process.env.BUNNY_NET_IMAGE;   
const imageval = (ProductList.image === "" || ProductList.image === " " || ProductList.image === "/N/A" || ProductList.image === "N/A" || ProductList.image === null || ProductList.image === undefined) 
  ? null : baseurl + ProductList.image; 
   const customizedProduct = {
noti_id:ProductList.noti_id,
user_id:user,
noti_title:(ProductList.noti_title)?ProductList.noti_title:"Quickart",
image: imageval,
noti_message:ProductList.noti_message,
read_by_user:ProductList.read_by_user,
created_at:ProductList.created_at
// Add or modify properties as needed
};
customizedProductData.push(customizedProduct);  
}
return customizedProductData;
}else{

return customizedProductData
}

}

const seosource = async (appDetatils) => {
    const utm_source = appDetatils.utm_source;
    const utm_campaign =  appDetatils.utm_campaign;
    const utm_network = appDetatils.utm_network;
    const utm_medium = appDetatils.utm_medium;
    const utm_keyword = appDetatils.utm_keyword;
    const placement = appDetatils.placement;
    const user_id = appDetatils.user_id;
    const device_id = appDetatils.device_id;
    const fcm_token = appDetatils.fcm_token;
    const platform = appDetatils.platform;



    const insert=await knex('seo_source')
    .insert({
      utm_source:utm_source,
      utm_campaign: utm_campaign,
      utm_network:utm_network,
      utm_medium:utm_medium,
      utm_keyword:utm_keyword,
      placement:placement,
      user_id:user_id,
      device_id:device_id,
      fcm_token:fcm_token,
      platform:platform
    });      
    return insert
}

const InsertPaymentNotification = async (appDetatils) => {
 
    const PaymentDetatils = appDetatils;
    const group_id = PaymentDetatils.order_number;
    const ordertype = PaymentDetatils.ordertype;
    const insert=await knex('payment_notification_details').insert({
    json_data:PaymentDetatils,
    group_id:group_id,
    order_type:ordertype,
    added_on: new Date()
    });      
    return insert
}

const successData = async (appDetatils) => {
    const PaymentDetatils = appDetatils;
    // const insert=await knex('payment_notification_details').insert({
    // json_data:PaymentDetatils,
    // added_on: new Date()
    // });      
   // return insert
   return PaymentDetatils
}

const failureData = async (appDetatils) => {
    const PaymentDetatils = appDetatils;
    // const insert=await knex('payment_notification_details').insert({
    // json_data:PaymentDetatils,
    // : new Date()
    // });      
    return PaymentDetatils
}

const getNotification = async (getnotification) => {
    group_id = getnotification.order_id;
    
  
    
    notifybys = await knex('payment_notification_details')
            .where('group_id',group_id)
            .first();
            
    const dataString = notifybys.json_data;
    const data = JSON.parse(dataString);

    // Access and print custom_data
   // const customData = data.custom_data;


   return data.custom_data;
    // const customdata = notifylist.custom_data;
    // return customdata;
    // if(notifybys){ 
    //     custom_data = customdata;
    //     return custom_data;
    // }else{
    //     return false;
    // }
}

const findByGroupId = async (getnotification) => {
  group_id = getnotification.order_id;
 
  notifybys = await knex('payment_notification_details')
          .where('group_id',group_id)
          .first();
        
  return notifybys;
}

module.exports = {
notificationlist,
InsertPaymentNotification,
successData,
failureData,
seosource,
getNotification,
findByGroupId
};