const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library

const getrecentSearch = async (appDetatils) => {
  const user_id = appDetatils.user_id;
  const device_id = appDetatils.device_id;
  if(user_id){
    return await knex ('recent_search')
    .where('user_id', user_id)
    .orderBy('id','DESC')
    .limit(5)
  }else{
    return await knex ('recent_search')
    .where('device_id', device_id)
    .orderBy('id','DESC')
    .limit(5)
  }
   
}

const gettrenproducts = async (appDetatils) => {
  const store_id = appDetatils.store_id;
 
  if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        trendsearch = await knex('trending_search')
                .join ('store_products', 'trending_search.varient_id', '=', 'store_products.varient_id')
                .join ('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
			          .join ('product', 'product_varient.product_id', '=', 'product.product_id')
                .leftJoin ('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
                .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
                .join('store', 'store_products.store_id', '=', 'store.id')
                .select('product.fcat_id','product.percentage','product.availability', 'tbl_country.country_icon','store_products.stock','store_products.store_id','product_varient.varient_id','product.product_id','product.product_name',
                knex.raw(`CONCAT('${baseurl}', product.product_image) as product_image`),
                knex.raw(`CONCAT('${baseurl}', product.thumbnail) as thumbnail`),
                 'product_varient.description', 'store_products.price', 'store_products.mrp',
                knex.raw(`CONCAT('${baseurl}', product_varient.varient_image) as varient_image`),
                knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
                'product_varient.unit','product_varient.quantity','product.type')
                .groupBy('store_products.stock','store_products.store_id','product_varient.varient_id','product.product_id','product.product_name', 'product.product_image', 'product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity','product.type')    
                .where('store_products.store_id', store_id);
                const customizedProductData = [];
                for (let i = 0; i < trendsearch.length; i++) {
                  const ProductList = trendsearch[i];
                  const currentDate = new Date();
                  const deal = await knex('deal_product')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .where('deal_product.valid_from', '<=', currentDate)
                  .where('deal_product.valid_to', '>', currentDate)
                  .first();
                 
                  let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                  }
                  if(user_id){ 
                        // Wishlist check 
                        // Wishlist check 
                        var isFavourite='';
                        var notifyMe='';
                        var cartQty=0;
                        const wishList = await knex('wishlist')
                        .select('*')
                        .where('varient_id',ProductList.varient_id)
                        .where('user_id',user_id);

                        isFavourite = wishList.length > 0 ? 'true' : 'false';
                
                        // cart qty check 
                        const CartQtyList = await knex('store_orders')
                        .where('varient_id',ProductList.varient_id)
                        .where('store_approval',user_id)
                        .where('order_cart_id','incart')
                        .whereNull('subscription_flag')
                        .where('store_id',store_id)
                        .first();
                        cartQty = CartQtyList ? CartQtyList.qty : 0;
                        

                        const cnotify_me = await knex('product_notify_me')
                        .where('varient_id', ProductList.varient_id)
                        .where('user_id', user_id);
                        notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                        const subprod = await knex('store_orders')
                        .select('store_orders.percentage')
                        .where('store_orders.varient_id',ProductList.varient_id)
                        .where('store_approval',user_id)
                        .where('store_orders.subscription_flag',1)
                        .where('store_orders.order_cart_id', "incart")
                        .first();
                
                        if(subprod){
                          isSubscription = 'true'
                        }else{
                          isSubscription = 'false'
                          
                        }


                    }else{
                          notifyMe='false';
                          isFavourite='false';
                          cartQty=0;
                          isSubscription = 'false';
                    }

                    const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                    const finalsubprice =  ProductList.mrp - sub_price;
                    const subscription_price = parseFloat(finalsubprice.toFixed(2));
                    
                       if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }

                    if (Number.isInteger(price)) {
                    priceval = price + '.001'
                    }else{
                    priceval = price
                    }
                    if (Number.isInteger(ProductList.mrp)) {
                    mrpval = ProductList.mrp + '.001'
                    }else{
                    mrpval = ProductList.mrp
                    }
                    
                    if(ProductList.fcat_id != null){
                        fcatinput = ProductList.fcat_id;
                        const resultArray = fcatinput.split(',').map(Number);
                        const ftaglist = await knex('feature_categories') 
                                  .whereIn('id', resultArray)
                                  .where('status',1)
                                  .where('is_deleted', 0)
                                  .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
                        feature_tags  = ftaglist;
                      }else{
                        feature_tags = [];
                      }

                    const customizedProduct = {
                      stock: ProductList.stock,      
                      store_id: store_id,
                      varient_id: ProductList.varient_id,
                      product_id: ProductList.product_id,
                      product_name: ProductList.product_name,
                      product_image: ProductList.product_image+"?width=200&height=200&quality=100",
                      thumbnail: ProductList.thumbnail,
                      description:ProductList.description,
                      price: parseFloat(priceval),
                      mrp: parseFloat(mrpval),
                      varient_image: ProductList.varient_image,
                      discountper: ProductList.discountper,
                      avgrating:0,
                      notify_me: notifyMe,
                      isFavourite: isFavourite,
                      cart_qty: cartQty,
                      unit: ProductList.unit,
                      quantity: ProductList.quantity,
                      type: ProductList.type,
                      percentage: ProductList.percentage,
                      isSubscription:isSubscription,
                      subscription_price:subscription_price,
                      availability:ProductList.availability,
                      feature_tags:feature_tags,
                      country_icon :countryicon
                      // Add or modify properties as needed
                      };

                      customizedProductData.push(customizedProduct);  
                }

                return customizedProductData;
}

const gettrendbrands = async (appDetatils) => {
  const store_id = appDetatils.store_id;

   const baseurl =  process.env.BUNNY_NET_IMAGE;
  return await knex('brands')
     .select('brands.cat_id','brands.title',  knex.raw(`CONCAT('${baseurl}', brands.image) as image`))
     .join('trending_brand','trending_brand.category_id','brands.cat_id')
     .where('brands.status',1)
     .orderBy('brands.cat_id', 'asc');

}

const getUniversalSearch = async (appDetatils) => {
   
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
   

    const store_id = appDetatils.store_id
    const keyword = appDetatils.keyword
   // const user_id = appDetatils.user_id
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    const device_id = appDetatils.device_id
    const byname  = appDetatils.byname
    const subcatid = appDetatils.sub_cat_id
    const cat_id = appDetatils.cat_id


    const pageFilter = appDetatils.page; // You can adjust the page number dynamically
    const perPage = appDetatils.perpage;
    
    const minprice = parseFloat(appDetatils.min_price)
    const  maxprice = parseFloat(appDetatils.max_price)
    const  mindiscount = parseFloat(appDetatils.min_discount)
    const  maxdiscount = parseFloat(appDetatils.max_discount)
   
   
    let categoryarray;
    if (cat_id !== "null") {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }
    
   
 
      const topsellingsQuery = knex('store_products')
      .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .join('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
      .select(
        'store_products.stock',
        'product_varient.varient_id',
        'product_varient.description',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'store_products.price',
        'store_products.mrp',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
        knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
       )
      .groupBy(
        'store_products.store_id',
        'product_varient.varient_id',
        'product.product_id'
      )
      .where('store_products.store_id', store_id)
      .where('product.hide', 0)
      .where('product.is_delete', 0);
   
     
      //if (cat_id !== "null") {
      //if (categoryarray.length > 0)  {
      if (categoryarray)  {
      topsellingsQuery.whereIn('product.cat_id', categoryarray);
      }
    
      if (subcatid !== "null") {
      topsellingsQuery.where('product.cat_id', subcatid);
      }
      
      if(keyword){
        // additionalcat.where('title', byname);
        topsellingsQuery.where('product.product_name', 'like', `%${keyword}%`)
         //additionalcat.whereLike('title', byname);
       }
      
       if (byname) {
        topsellingsQuery.orderBy('product.product_name', 'byname');
      }

     // return topsellingsQuery
      if ((minprice === 0 || minprice) && maxprice) {
      topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
      }
     
  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
      mindiscount,
      maxdiscount,
      mindiscount,
      maxdiscount,
    ]);
  }
  
//   if (sortprice === 'ltoh') {
//     topsellingsQuery.orderBy('store_products.price', 'ASC');
//   }
  
//   if (sortprice === 'htol') {
//     topsellingsQuery.orderBy('store_products.price', 'DESC');
//   }
  
//   if (sortname === 'atoz') {
//     topsellingsQuery.orderBy('product.product_name', 'ASC');
//   }
  
//   if (sortname === 'ztoa') {
//     topsellingsQuery.orderBy('product.product_name', 'DESC');
//   }
  

  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);
  
     
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
         const ProductList = productDetail[i];
         const currentDate = new Date();
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
       //for deviceid
       if(device_id){
                check=await knex('recent_search')
                .where('device_id',device_id);
                
                checkww=await knex('recent_search')
                .where('device_id',device_id)
                .first();   

                deletesame=await knex('recent_search')
                .where('keyword',keyword)
                .delete(); 
                
                if(check.length>=10){
                    chec=await knex('recent_search')
                    .where('id',checkww.id)
                    .delete();  
                }        
                add = await knex('recent_search')
                .insert({
                  device_id:device_id,
                    keyword:keyword
                });

       }

       if(user_id){ 

        check=await knex('recent_search')
        .where('user_id',user_id);
        
        checkww=await knex('recent_search')
        .where('user_id',user_id)
        .first();   

        deletesame=await knex('recent_search')
        .where('keyword',keyword)
        .delete(); 
        
        if(check.length>=10){
            chec=await knex('recent_search')
            .where('id',checkww.id)
            .delete();  
        }        
        add = await knex('recent_search')
        .insert({
            user_id:user_id,
            keyword:keyword
        });




        
         // Wishlist check 
          // Wishlist check 
          var isFavourite='';
          var notifyMe='';
          var cartQty=0;
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .whereNull('subscription_flag')
         .where('store_id',store_id)
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
           isSubscription = 'false'
         }

         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));

         const baseurl =  process.env.BUNNY_NET_IMAGE;
         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
             thumbnail: ProductList.thumbnail,
             description:ProductList.description,
             price: price,
             mrp: ProductList.mrp,
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             discountper: ProductList.discountper,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
              availability:ProductList.availability,
             countrating:0,
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
 
     return customizedProductData;
   };

   const getSearchbybannerold = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
        //const user_id = appDetatils.user_id
        if(appDetatils.user_id != "null" ){
          user_id = appDetatils.user_id
      }else{
          user_id = appDetatils.device_id
      }
        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname
    
        const pageFilter = appDetatils.page; // You can adjust the page number dynamically
        const perPage = appDetatils.perpage;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)
        // let words = 0;
        //  if(appDetatils.keyword != "All"){
        //   const inputString = keyword;
        //   let words = inputString.split(/\s+/).filter(word => word.length > 3);
        //  }
         
          let words = [];
        if (appDetatils.keyword !== 'All') {
          words = keyword.split(/\s+/).filter(word => word.length > 3);
        }
    
        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
           
        }else
        if(stock == 'all' || stock == "null"){
             stock="!=";
             by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    
       
        //let categoryarray1 = [];
        let categoryarray;
        if (cat_id !== "null") {
        categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
        }
        //const categoryarray = categoryarray1.push(cat_id); 
        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
         .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
         .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
         )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('store_products.store_id', store_id)
        .where('product.hide', 0)
        .where('product.is_delete', 0);
     
       
      

        //if (cat_id !== "null") {
        //if (categoryarray.length > 0)  {
        if (categoryarray)  {
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }
       
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
     
         
        // if( words.length > 0 && keyword != "All"){
       
        //   //const patterns = ['Milk', 'bannana', 'Combo'];
        //   const patterns = words
        //     topsellingsQuery.where(builder => {
        //       patterns.forEach(pattern => {
        //         builder.orWhere('product.product_name', 'like', `%${pattern}%`);
        //       });
        //     });
        //      //additionalcat.whereLike('title', byname);
        //  }
         
         if(stock){
            topsellingsQuery.where('store_products.stock',stock,by)
         }
         if (byname) {
          topsellingsQuery.orderBy('product.product_name', 'byname');
        }
    
       // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
       
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }
    
          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }
    
            if (words.length > 0 && keyword !== 'All') {
              topsellingsQuery.where(builder => {
                words.forEach(pattern => {
                  builder.orWhere('product.product_name', 'like', `%${pattern}%`);
                });
              });
            }
            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
            
               
               const customizedProductData = [];
                 for (let i = 0; i < productDetail.length; i++) {
                   const ProductList = productDetail[i];
                   const currentDate = new Date();
                   const deal = await knex('deal_product')
                   .where('varient_id', ProductList.varient_id)
                   .where('store_id', store_id)
                   .where('deal_product.valid_from', '<=', currentDate)
                   .where('deal_product.valid_to', '>', currentDate)
                   .first();
                  
                   let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                 }
           
                   //for deviceid
               if(device_id){
                
                    check=await knex('recent_search')
                    .where('device_id',device_id);
                    
                    checkww=await knex('recent_search')
                    .where('device_id',device_id)
                    .first();   
    
                    deletesame=await knex('recent_search')
                    .where('keyword',keyword)
                    .delete(); 
                      
                    if(check.length>=10){
                        chec=await knex('recent_search')
                        .where('id',checkww.id)
                        .delete();  
                    }    
                    
                   
                   add = await knex('recent_search')
                    .insert({
                        device_id:device_id,
                        keyword:keyword
                    });
                      
                        
        
               }
           
                 if(user_id){ 
          
          
                  check=await knex('recent_search')
                  .where('user_id',user_id);
                  
                  checkww=await knex('recent_search')
                  .where('user_id',user_id)
                  .first();   
          
                  deletesame=await knex('recent_search')
                  .where('keyword',keyword)
                  .delete(); 
                  
                  if(check.length>=10){
                      chec=await knex('recent_search')
                      .where('id',checkww.id)
                      .delete();  
                  }        
                  add = await knex('recent_search')
                  .insert({
                      user_id:user_id,
                      keyword:keyword
                  });
          
          
          
          
                  
                   // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                    const wishList = await knex('wishlist')
                   .select('*')
                   .where('varient_id',ProductList.varient_id)
                   .where('user_id',user_id);
          
                   isFavourite = wishList.length > 0 ? 'true' : 'false';
            
                   // cart qty check 
                   const CartQtyList = await knex('store_orders')
                   .where('varient_id',ProductList.varient_id)
                   .where('store_approval',user_id)
                   .where('order_cart_id','incart')
                   .whereNull('subscription_flag')
                   .where('store_id',store_id)
                   .first();
                   cartQty = CartQtyList ? CartQtyList.qty : 0;
                   
           
                   const cnotify_me = await knex('product_notify_me')
                   .where('varient_id', ProductList.varient_id)
                   .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                    const subprod = await knex('store_orders')
                    .select('store_orders.percentage')
                    .where('store_orders.varient_id',ProductList.varient_id)
                    .where('store_approval',user_id)
                    .where('store_orders.subscription_flag',1)
                    .where('store_orders.order_cart_id', "incart")
                    .first();
            
                    if(subprod){
                      isSubscription = 'true'
                    }else{
                      isSubscription = 'false'
                      
                    }
           
           
                   }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                   }

                   const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                   const finalsubprice =  ProductList.mrp - sub_price;
                   const subscription_price = parseFloat(finalsubprice.toFixed(2));

                   const baseurl =  process.env.BUNNY_NET_IMAGE;
                   
                     if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }
                       
                   const customizedProduct = {
                       stock: ProductList.stock,        
                       varient_id: ProductList.varient_id,
                       product_id: ProductList.product_id,
                       product_name: ProductList.product_name,
                       product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                       thumbnail: ProductList.thumbnail,
                       description:ProductList.description,
                       price: price,
                       mrp: ProductList.mrp,
                       unit: ProductList.unit,
                       quantity: ProductList.quantity,
                       type: ProductList.type,
                       percentage: ProductList.percentage,
                       isSubscription:isSubscription,
                       subscription_price:subscription_price,
                        availability:ProductList.availability,
                       //discountper: ProductList.discountper,
                       discountper:0,
                       avgrating:0,
                       notify_me: notifyMe,
                       isFavourite: isFavourite,
                       cart_qty: cartQty,
                       countrating:0,
                       country_icon : countryicon, 
                       varients:null
                       // Add or modify properties as needed
                       };
                   
                     customizedProductData.push(customizedProduct);  
               
                 }
           
               return customizedProductData;
    }
    
   const getSearchbybanner = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
        const baseurl =  process.env.BUNNY_NET_IMAGE;
        //const user_id = appDetatils.user_id

        // If no product found for the keyword, return early
        // if (!keyword) {
        // return "No products found for the given keyword";
        // }

      if(appDetatils.user_id != "null" ){
          user_id = appDetatils.user_id
      }else{
          user_id = appDetatils.device_id
      }

        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const brand_id = appDetatils.brand_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname
        const banner_id = appDetatils.banner_id
        const banner_type = appDetatils.banner_type

      
        let banner =[];
        if(banner_type == 'product'){
           banner = await knex('sec_banner')
        .select('banner_id', 'banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`),'parent_cat_id','cat_id','varient_id')
        .where('banner_id', banner_id)
        .first();
        }else{
             banner = await knex('store_banner')
        .select('banner_id', 'banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`),'parent_cat_id','cat_id','varient_id')
        .where('banner_id', banner_id)
        .first();
       
        }

        let categoryProductIds = [];
        
        if(banner.varient_id && banner.cat_id && banner.parent_cat_id){
         productIds = banner.varient_id.split(',');  
         categoryProductIds = productIds.map(Number);  
        }

        if((banner.varient_id == '' || banner.varient_id == null)  && banner.cat_id  && banner.parent_cat_id){
           const subcategories = banner.cat_id.split(',');
           const productIds = await knex('product')
          .from('product')
          .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
          .join('product_varient', 'product.product_id', 'product_varient.product_id')
          .join('store_products',  'store_products.varient_id', '=', 'product_varient.varient_id')
          .whereIn('product.cat_id', subcategories)
          .andWhere('product.hide', '=', 0)
          .andWhere('product.is_delete', '=', 0)
          .andWhere('store_products.stock','>',0)
          .pluck('product.product_id');
 
          categoryProductIds = productIds;
          // console.log(categoryProductIds,categoryProductIds.length);
        }

        if((banner.varient_id == '' || banner.varient_id == null) && (banner.cat_id == '' || banner.cat_id == null) && banner.parent_cat_id){
          const parent_cat_id = banner.parent_cat_id.split(',');
          const subcategories = await knex('categories')
          .whereIn('parent', parent_cat_id)
          .where('status',1).pluck('cat_id');
          // console.log('subcategories',subcategories);

           const productIds = await knex('product')
          .from('product')
          .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
          .join('product_varient', 'product.product_id', 'product_varient.product_id')
          .join('store_products', 'store_products.varient_id', '=', 'product_varient.varient_id')
          .whereIn('product.cat_id', subcategories)
          .andWhere('product.hide', '=', 0)
          .andWhere('product.is_delete', '=', 0)
          .andWhere('store_products.stock','>',0)
          .pluck('product.product_id');

          categoryProductIds = productIds;
        }

        // console.log(categoryProductIds);
    
        //const pageFilter = 1; // You can adjust the page number dynamically
        //const perPage = 50;
        
        const pageFilter = appDetatils.page; // You can adjust the page number dynamically
        const perPage =  appDetatils.perpage;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)
        // let words = 0;
        //  if(appDetatils.keyword != "All"){
        //   const inputString = keyword;
        //   let words = inputString.split(/\s+/).filter(word => word.length > 3);
        //  }
         
          let words = [];
        if (appDetatils.keyword !== 'All') {
          words = keyword.split(/\s+/).filter(word => word.length > 3);
        }
        
    
        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
           
        }else
        if(stock == 'all' || stock == "null"){
             stock="!=";
             by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    


        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
         .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
         .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          'product.brand_id',
          'product.cat_id',
          'product.fcat_id',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
         )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('product.hide', 0)
        .where('product.is_delete', 0)
        .whereIn('product.product_id', categoryProductIds);
     
        //    console.log(categoryProductIds,categoryProductIds.length);
        // if(brand_id && brand_id != ' ')
        // {
        // var cleanedKeyword = keyword.trim().replace(/\s+/g, ' ');  
        // var categoryID = await knex('sec_banner').where('sec_banner.banner_name', 'like', `%${cleanedKeyword}%`).first();
        // categoryarray = await knex('categories').where('parent',categoryID.cat_id).pluck('cat_id');
        // topsellingsQuery.whereIn('product.cat_id', categoryarray);
        // }else
        // {

        // if(keyword != ''){
        //   var cleanedKeyword = keyword.trim().replace(/\s+/g, ' ');    
        //   var categoryID = await knex('store_banner').where('store_banner.banner_name', 'like', `%${cleanedKeyword}%`).first(); 
        //   topsellingsQuery.where('product.cat_id', categoryID.cat_id);
        // }  
      
        // }
       
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
         if(stock){
            // topsellingsQuery.where('store_products.stock',stock,by)
         }

       // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
       
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }
    
          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }
    
            // const productDetail = await topsellingsQuery;
            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
              
               const customizedProductData = [];
                 for (let i = 0; i < productDetail.length; i++) {
                   const ProductList = productDetail[i];
                   const currentDate = new Date();
                   const deal = await knex('deal_product')
                   .where('varient_id', ProductList.varient_id)
                   .where('store_id', store_id)
                   .where('deal_product.valid_from', '<=', currentDate)
                   .where('deal_product.valid_to', '>', currentDate)
                   .first();
                  
                   let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                 }
           
                 if(user_id){ 
          
          
                  check=await knex('recent_search')
                  .where('user_id',user_id);
                  
                  checkww=await knex('recent_search')
                  .where('user_id',user_id)
                  .first();   
          
                  deletesame=await knex('recent_search')
                  .where('keyword',keyword)
                  .delete(); 
                  
                  if(check.length>=10){
                      chec=await knex('recent_search')
                      .where('id',checkww.id)
                      .delete();  
                  }        
                  add = await knex('recent_search')
                  .insert({
                      user_id:user_id,
                      keyword:keyword
                  });
          
          
          
          
                  
                   // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                    const wishList = await knex('wishlist')
                   .select('*')
                   .where('varient_id',ProductList.varient_id)
                   .where('user_id',user_id);
          
                   isFavourite = wishList.length > 0 ? 'true' : 'false';
            
                   // cart qty check 
                   const CartQtyList = await knex('store_orders')
                   .where('varient_id',ProductList.varient_id)
                   .where('store_approval',user_id)
                   .where('order_cart_id','incart')
                   .whereNull('subscription_flag')
                   .where('store_id',store_id)
                   .first();
                   cartQty = CartQtyList ? CartQtyList.qty : 0;
                   
           
                   const cnotify_me = await knex('product_notify_me')
                   .where('varient_id', ProductList.varient_id)
                   .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                    const subprod = await knex('store_orders')
                    .select('store_orders.percentage')
                    .where('store_orders.varient_id',ProductList.varient_id)
                    .where('store_approval',user_id)
                    .where('store_orders.subscription_flag',1)
                    .where('store_orders.order_cart_id', "incart")
                    .first();
            
                    if(subprod){
                      isSubscription = 'true'
                    }else{
                      isSubscription = 'false'
                      
                    }
           
           
                   }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                   }

                   const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                   const finalsubprice =  ProductList.mrp - sub_price;
                   const subscription_price = parseFloat(finalsubprice.toFixed(2));

                   const baseurl =  process.env.BUNNY_NET_IMAGE;
                      if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }
                   
                      if (Number.isInteger(price)) {
                      priceval = price + '.001'
                      }else{
                      priceval = price
                      }
                      if (Number.isInteger(ProductList.mrp)) {
                      mrpval = ProductList.mrp + '.001'
                      }else{
                      mrpval = ProductList.mrp
                      }
                    
                    if(ProductList.fcat_id != null){
                    fcatinput = ProductList.fcat_id;
                    const resultArray = fcatinput.split(',').map(Number);
                    const ftaglist = await knex('feature_categories') 
                              .whereIn('id', resultArray)
                              .where('status',1)
                              .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
                    feature_tags  = ftaglist;
                  }else{
                    feature_tags = [];
                  }

                   const customizedProduct = {
                       stock: ProductList.stock, 
                       cat_id:ProductList.cat_id,
                       varient_id: ProductList.varient_id,
                       product_id: ProductList.product_id,
                       brand_id: ProductList.brand_id,
                       product_name: ProductList.product_name,
                       product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                       thumbnail: ProductList.thumbnail,
                       description:ProductList.description,
                       price: parseFloat(priceval),
                       mrp: parseFloat(mrpval),
                       unit: ProductList.unit,
                       quantity: ProductList.quantity,
                       type: ProductList.type,
                       percentage: ProductList.percentage,
                       isSubscription:isSubscription,
                       subscription_price:subscription_price,
                        availability:ProductList.availability,
                       //discountper: ProductList.discountper,
                       discountper:0,
                       avgrating:0,
                       notify_me: notifyMe,
                       isFavourite: isFavourite,
                       cart_qty: cartQty,
                       countrating:0,
                       country_icon : countryicon, 
                       feature_tags:feature_tags,
                       varients:null,
                       page :pageFilter,
                       perPage :perPage,
                       // Add or modify properties as needed
                       };
                   
                     customizedProductData.push(customizedProduct);  
               
                 }
           
               return customizedProductData;
    }
    
const getSearchbystore = async (appDetatils) => {
        await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
      // const user_id = appDetatils.user_id
      if(appDetatils.user_id != "null" ){
        user_id = appDetatils.user_id
        }else{
            user_id = appDetatils.device_id
        }
        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname

        const pageFilter = appDetatils.page; // You can adjust the page number dynamically
        const perPage = appDetatils.perpage;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)

        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
          
        }else
        if(stock == 'all' || stock == "null"){
            stock="!=";
            by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    
      
        //let categoryarray1 = [];
        let categoryarray;
        if (cat_id !== "null") {
        categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
        }
        //const categoryarray = categoryarray1.push(cat_id); 
        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          'product.fcat_id',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
        )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('store_products.store_id', store_id)
        .where('product.hide', 0)
        .where('product.is_delete', 0);

        if(keyword == 'daily')
        {
        // List of IDs
        const ids = [122,2,3,16,23,149,21,55,56,57,58,59,72,94,150,9,20,132,37,48,50,99,101,102,147,180,47,49,91,100,146,148,179];  
        topsellingsQuery.whereIn('product.availability', ['quick','all']);
        topsellingsQuery.whereIn('product.cat_id', ids) // Filter by these IDs
        topsellingsQuery.orderByRaw(`FIELD(product.cat_id, ${ids.join(',')})`); // Maintain the custom order  
        }

        if(keyword == 'subscription')
        {
        // List of IDs
        const ids = [122,2,3,16,23,149,37,48,50,99,101,102,147,180,47,49,91,100,146,148,179,9,20,132,21,55,56,57,58,59,72,94,150];
        topsellingsQuery.whereIn('product.availability', ['subscription','all']);  
        topsellingsQuery.whereIn('product.cat_id', ids) // Filter by these IDs
        topsellingsQuery.orderByRaw(`FIELD(product.cat_id, ${ids.join(',')})`); // Maintain the custom order
  
        }
       
        //if (cat_id !== "null") {
        //if (categoryarray.length > 0)  {
        if (categoryarray)  {
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }
      
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
        if(keyword != 'daily' && keyword != 'subscription'){
          // additionalcat.where('title', byname);
          topsellingsQuery.where('product.product_name', 'like', `%${keyword}%`)
          //additionalcat.whereLike('title', byname);
        }
        if(stock){
            // topsellingsQuery.where('store_products.stock',stock,by)
        }
        if (byname) {
          // topsellingsQuery.orderBy('product.product_name', 'byname');
        }

      // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
      
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }

          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }


            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
            
              
              const customizedProductData = [];
                for (let i = 0; i < productDetail.length; i++) {
                  const ProductList = productDetail[i];
                  const currentDate = new Date();
                  const deal = await knex('deal_product')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .where('deal_product.valid_from', '<=', currentDate)
                  .where('deal_product.valid_to', '>', currentDate)
                  .first();
                  
                  let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                }
                
                //for device_id
          if(device_id){

                  try {
                      check=await knex('recent_search')
                      .where('device_id',device_id);
                      
                      checkww=await knex('recent_search')
                      .where('device_id',device_id)
                      .first();   

                      deletesame=await knex('recent_search')
                      .where('keyword',keyword)
                      .delete(); 
                      
                      if(check.length>=10){
                          chec=await knex('recent_search')
                          .where('id',checkww.id)
                          .delete();  
                      }        
                      add = await knex('recent_search')
                      .insert({
                        device_id:device_id,
                          keyword:keyword
                      });
                    } catch (error) {

                    } finally {
      
                    }

              }
          
                if(user_id){ 
          

                  try {
                  // Check recent searches for the user
                  const check = await knex('recent_search')
                  .where('user_id', user_id);

                  // Get the most recent search entry for the user
                  const checkww = await knex('recent_search')
                  .where('user_id', user_id)
                  .first();

                  // Delete entries with the same keyword
                  const deletesame = await knex('recent_search')
                  .where('keyword', keyword)
                  .delete();

                  // Check if there are 10 or more recent searches
                  if (check.length >= 10) {
                  if (checkww) {
                  // Delete the oldest entry (the one with the id from checkww)
                  await knex('recent_search')
                  .where('id', checkww.id)
                  .delete();
                  }
                  }
                  // Add the new search entry
                  const add = await knex('recent_search')
                  .insert({
                  user_id: user_id,
                  keyword: keyword
                  });

                  } catch (error) {

                  } finally {

                  }
      
                  // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                if (user_id) {
                const wishList = await knex('wishlist')
                .select('*')
                .where('varient_id',ProductList.varient_id)
                .where('user_id',user_id);
                isFavourite = wishList.length > 0 ? 'true' : 'false';
                }else
                {
                isFavourite='false'; 
                }
            
                  // cart qty check 
                  if(user_id){
                  const CartQtyList = await knex('store_orders')
                  .where('varient_id',ProductList.varient_id)
                  .where('store_approval',user_id)
                  .where('order_cart_id','incart')
                  .whereNull('subscription_flag')
                  .where('store_id',store_id)
                  .first();
                  cartQty = CartQtyList ? CartQtyList.qty : 0;
                  }else
                  {
                  cartQty=0; 
                  }
                  
                  if (user_id) {
                  const cnotify_me = await knex('product_notify_me')
                  .where('varient_id', ProductList.varient_id)
                  .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
                  }else
                  {
                    notifyMe = 'false';
                  }
                  isSubscription='false';
                  }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                  }
                  const baseurl =  process.env.BUNNY_NET_IMAGE;
                  const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                  const finalsubprice =  ProductList.mrp - sub_price;
                  const subscription_price = parseFloat(finalsubprice.toFixed(2));
                  
                  
                          if(ProductList.country_icon == null){
                              countryicon = null
                          }else{
                              countryicon =  baseurl + ProductList.country_icon
                          }

                    if (Number.isInteger(price)) {
                    priceval = price + '.001'
                    }else{
                    priceval = price
                    }
                    if (Number.isInteger(ProductList.mrp)) {
                    mrpval = ProductList.mrp + '.001'
                    }else{
                    mrpval = ProductList.mrp
                    }
                    
                    if(ProductList.fcat_id != null){
                        fcatinput = ProductList.fcat_id;
                        const resultArray = fcatinput.split(',').map(Number);
                        const ftaglist = await knex('feature_categories') 
                                  .whereIn('id', resultArray)
                                  .where('status',1)
                                  .where('is_deleted', 0)
                                  .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
                        feature_tags  = ftaglist;
                    }else{
                        feature_tags = [];
                    }

                          
                  const customizedProduct = {
                      stock: ProductList.stock,        
                      varient_id: ProductList.varient_id,
                      product_id: ProductList.product_id,
                      product_name: ProductList.product_name,
                      product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                      thumbnail: ProductList.thumbnail,
                      description:ProductList.description,
                      price: parseFloat(priceval),
                      mrp: parseFloat(mrpval),
                      unit: ProductList.unit,
                      quantity: ProductList.quantity,
                      type: ProductList.type,
                      discountper: ProductList.discountper,
                      avgrating:0,
                      notify_me: notifyMe,
                      isFavourite: isFavourite,
                      cart_qty: cartQty,
                      countrating:0,
                      percentage: ProductList.percentage,
                      isSubscription:isSubscription,
                      subscription_price:subscription_price,
                      availability:ProductList.availability,
                      country_icon : countryicon, 
                      varients:null,
                      feature_tags:feature_tags
                      // Add or modify properties as needed
                      };
                  
                    customizedProductData.push(customizedProduct);  
              
                }
          
              return customizedProductData;
};

const getSearchbyBrands = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
  const store_id = appDetatils.store_id
  const keyword = appDetatils.keyword
  if(appDetatils.user_id != "null" ){
  user_id = appDetatils.user_id
  }else{
  user_id = appDetatils.device_id
  }
  const device_id = appDetatils.device_id
  const byname  = appDetatils.byname
  const subcatid = appDetatils.sub_cat_id
  const cat_id = appDetatils.cat_id
  const sortprice = appDetatils.sortprice
  const sortname = appDetatils.sortname
  const brand_id = appDetatils.brand_id

  const pageFilter = appDetatils.page; // You can adjust the page number dynamically
  const perPage = appDetatils.perpage;

  const minprice = parseFloat(appDetatils.min_price)
  const  maxprice = parseFloat(appDetatils.max_price)
  const  mindiscount = parseFloat(appDetatils.min_discount)
  const  maxdiscount = parseFloat(appDetatils.max_discount)
  stock = appDetatils.stock;

  const topsellingsQuery = knex('store_products')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
  .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
  .select(
  'store_products.stock',
  'product_varient.varient_id',
  'product_varient.description',
  'product.product_id',
  'product.product_name',
  'product.brand_id',
  'product.product_image',
  'product.thumbnail',
  'store_products.price',
  'store_products.mrp',
  'product_varient.unit',
  'product_varient.quantity',
  'product.type',
  'tbl_country.country_icon',
  'product.percentage',
  'product.availability',
  'product.fcat_id',
  knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
  knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
  )
  .groupBy(
  'store_products.store_id',
  'product_varient.varient_id',
  'product.product_id'
  )
  .where('product.brand_id', brand_id)
  .where('product.hide', 0)
  .where('product.is_delete', 0);

  if ((minprice === 0 || minprice) && maxprice) {
  topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
  }

  if (mindiscount && maxdiscount) {
  topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
  mindiscount,
  maxdiscount,
  mindiscount,
  maxdiscount,
  ]);
  }

  if (sortprice === 'ltoh') {
  topsellingsQuery.orderBy('store_products.price', 'ASC');
  }

  if (sortprice === 'htol') {
  topsellingsQuery.orderBy('store_products.price', 'DESC');
  }

  if (sortname === 'atoz') {
  topsellingsQuery.orderBy('product.product_name', 'ASC');
  }

  if (sortname === 'ztoa') {
  topsellingsQuery.orderBy('product.product_name', 'DESC');
  }

  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);

  const customizedProductData = [];
  for (let i = 0; i < productDetail.length; i++) {
    const ProductList = productDetail[i];
    const currentDate = new Date();
    const deal = await knex('deal_product')
    .where('varient_id', ProductList.varient_id)
    .where('store_id', store_id)
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .first();
    
    let price=0;
    if (deal) {
    price = deal.deal_price;
    } else {
    const sp = await knex('store_products')
    .where('varient_id', ProductList.varient_id)
    .where('store_id', store_id)
    .first();
    price = sp.price;
  }

  //for device_id
  if(device_id){

    try {
        check=await knex('recent_search')
        .where('device_id',device_id);
        
        checkww=await knex('recent_search')
        .where('device_id',device_id)
        .first();   

        deletesame=await knex('recent_search')
        .where('keyword',keyword)
        .delete(); 
        
        if(check.length>=10){
            chec=await knex('recent_search')
            .where('id',checkww.id)
            .delete();  
        }        
        add = await knex('recent_search')
        .insert({
          device_id:device_id,
            keyword:keyword
        });
      } catch (error) {

      } finally {

      }

  }

  if(user_id){ 


    try {
    // Check recent searches for the user
    const check = await knex('recent_search')
    .where('user_id', user_id);

    // Get the most recent search entry for the user
    const checkww = await knex('recent_search')
    .where('user_id', user_id)
    .first();

    // Delete entries with the same keyword
    const deletesame = await knex('recent_search')
    .where('keyword', keyword)
    .delete();

    // Check if there are 10 or more recent searches
    if (check.length >= 10) {
    if (checkww) {
    // Delete the oldest entry (the one with the id from checkww)
    await knex('recent_search')
    .where('id', checkww.id)
    .delete();
    }
    }
    // Add the new search entry
    const add = await knex('recent_search')
    .insert({
    user_id: user_id,
    keyword: keyword
    });

    } catch (error) {

    } finally {

    }

    // Wishlist check 
      // Wishlist check 
      var isFavourite='';
  var notifyMe='';
  var cartQty=0;
  if (user_id) {
  const wishList = await knex('wishlist')
  .select('*')
  .where('varient_id',ProductList.varient_id)
  .where('user_id',user_id);
  isFavourite = wishList.length > 0 ? 'true' : 'false';
  }else
  {
  isFavourite='false'; 
  }

    // cart qty check 
    if(user_id){
    const CartQtyList = await knex('store_orders')
    .where('varient_id',ProductList.varient_id)
    .where('store_approval',user_id)
    .where('order_cart_id','incart')
    .whereNull('subscription_flag')
    .where('store_id',store_id)
    .first();
    cartQty = CartQtyList ? CartQtyList.qty : 0;
    }else
    {
    cartQty=0; 
    }
    
    if (user_id) {
    const cnotify_me = await knex('product_notify_me')
    .where('varient_id', ProductList.varient_id)
    .where('user_id', user_id);
      notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
    }else
    {
      notifyMe = 'false';
    }
      
    
        isSubscription='false';
      

    


    }else{
      notifyMe='false';
      isFavourite='false';
      cartQty=0;
      isSubscription = 'false';
    }
    const baseurl =  process.env.BUNNY_NET_IMAGE;
    const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
    const finalsubprice =  ProductList.mrp - sub_price;
    const subscription_price = parseFloat(finalsubprice.toFixed(2));
  
    if(ProductList.country_icon == null){
        countryicon = null
    }else{
        countryicon =  baseurl + ProductList.country_icon
    }

    if (Number.isInteger(price)) {
    priceval = price + '.001'
    }else{
    priceval = price
    }
    if (Number.isInteger(ProductList.mrp)) {
    mrpval = ProductList.mrp + '.001'
    }else{
    mrpval = ProductList.mrp
    }
    
   if(ProductList.fcat_id != null){
        fcatinput = ProductList.fcat_id;
        const resultArray = fcatinput.split(',').map(Number);
        const ftaglist = await knex('feature_categories') 
                  .whereIn('id', resultArray)
                  .where('status',1)
                  .where('is_deleted', 0)
                  .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
        feature_tags  = ftaglist;
      }else{
        feature_tags = [];
      }
            
    const customizedProduct = {
        stock: ProductList.stock,        
        varient_id: ProductList.varient_id,
        product_id: ProductList.product_id,
        brand_id: ProductList.brand_id,
        product_name: ProductList.product_name,
        product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
        thumbnail: ProductList.thumbnail,
        description:ProductList.description,
        price: parseFloat(priceval),
        mrp: parseFloat(mrpval),
        unit: ProductList.unit,
        quantity: ProductList.quantity,
        type: ProductList.type,
        discountper: ProductList.discountper,
        avgrating:0,
        notify_me: notifyMe,
        isFavourite: isFavourite,
        cart_qty: cartQty,
        countrating:0,
        percentage: ProductList.percentage,
        isSubscription:isSubscription,
        subscription_price:subscription_price,
        availability:ProductList.availability,
        country_icon : countryicon, 
        feature_tags:feature_tags,
        varients:null
        // Add or modify properties as needed
        };
    customizedProductData.push(customizedProduct);  
  }

  return customizedProductData;
  };

const getSearchbypopup = async  (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
    const {bannerid,store_id,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage,keyword} = appDetatils;
    const storeId = store_id;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = 200;
       //Varient Product variables
       var visFavourite='';
       var vnotifyMe='';
       var vcartQty=0;
       var vavgrating=0;
       var vcountrating=0
       var vdiscountper=0;
       //var bynames = (byname.toLowerCase() == 'fresh food') ? "Fresh Picks" : byname;
       //var bynames = (byname.toLowerCase() != 'fresh food' && byname.toLowerCase() =='') ? "DIWALI" : bynames;
     const currentDate = new Date().toISOString().split('T')[0];
       //return byname
      const additionalcat = knex('popup_banner')
                            .where('banner_id', bannerid);
      //if (cat_id) {
      if (cat_id !== "null") {
      additionalcat.where('id', cat_id);
      }
      const result = await additionalcat.select('*'); // Replace 'id' with the actual column you want to order by
      const results = result;
      const customizedData = [];
      for (let i = 0; i < results.length; i++) {
        const item = results[i];
        // const product_id=item.product_id;
        // const product_ids = product_id.split(',');
          let categoryProductIds = [];
            if(item.product_id && item.subcat_id && item.cat_id){
             productIds = item.product_id.split(',');
             categoryProductIds = productIds.map(Number);
            }
            if((item.product_id == '' || item.product_id == null)  && item.subcat_id  && item.cat_id){
              const subcategories = item.subcat_id.split(',');
              const productIds = await knex('product')
              .from('product')
              .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
              .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
              .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
              .whereIn('product.cat_id', subcategories)
              .andWhere('product.hide', '=', 0)
              .andWhere('product.is_delete', '=', 0).pluck('product.product_id');
              categoryProductIds = productIds;
            }
            if((item.product_id == '' || item.product_id == null) && (item.subcat_id == '' || item.subcat_id == null) && item.cat_id){
              const parent_cat_id = item.cat_id.split(',');
              const subcategories = await knex('categories')
              .whereIn('parent', parent_cat_id)
              .where('status',1).pluck('cat_id');
              // console.log('subcategories',subcategories);
              const productIds = await knex('product')
              .from('product')
              .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
              .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
              .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
              .whereIn('product.cat_id', subcategories)
              .andWhere('product.hide', '=', 0)
              .andWhere('product.is_delete', '=', 0).pluck('product.product_id');
              categoryProductIds = productIds;
            }
        const productDetail_s =knex('product')
        .select(
          'store_products.stock',
          'product_varient.varient_image',
          'product_varient.quantity',
          'product_varient.unit',
          'store_products.price',
          'store_products.mrp',
          'product_varient.description',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'product_varient.varient_id',
          'product.product_id',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          'product.fcat_id',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
        )
        .from('product')
        .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
        .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .leftJoin('add_occproduct_order', 'add_occproduct_order.product_id', '=', 'product.product_id')
        //.whereIn('product.product_id', product_ids)
        .whereIn('product.product_id', categoryProductIds)
        .andWhere('product.hide', '=', 0)
        .where('product.is_delete', 0)
        .where('store_products.stock','>',0)
        .orderBy('add_occproduct_order.orders', 'asc');
      const productDetails = await productDetail_s.offset((pageFilter - 1) * perPage)
      .limit(perPage);
      const productDetail = productDetails.filter((product, index, self) => {
      return index === self.findIndex((p) => p.product_id === product.product_id);
      });
       const customizedProductData = [];
         for (let i = 0; i < productDetail.length; i++) {
          var isFavourite='';
          var notifyMe='';
          var cartQty=0;
           const ProductList = productDetail[i];
           const currentDate = new Date();
           const deal = await knex('deal_product')
           .where('varient_id', ProductList.varient_id)
           .where('store_id', store_id)
           .where('deal_product.valid_from', '<=', currentDate)
           .where('deal_product.valid_to', '>', currentDate)
           .first();
           let price=0;
          if (deal) {
          price = deal.deal_price;
          } else {
          const sp = await knex('store_products')
          .where('varient_id', ProductList.varient_id)
          .where('store_id', store_id)
          .first();
          price = sp.price;
         }
         if(user_id){
           // Wishlist check
            const wishList = await knex('wishlist')
           .select('*')
           .where('varient_id',ProductList.varient_id)
           .where('user_id',user_id);
           isFavourite = wishList.length > 0 ? 'true' : 'false';
           // cart qty check
           const CartQtyList = await knex('store_orders')
           .where('varient_id',ProductList.varient_id)
           .where('store_approval',user_id)
           .where('order_cart_id','incart')
           .where('store_id',store_id)
           .whereNull('subscription_flag')
           .first();
           cartQty = CartQtyList ? CartQtyList.qty : 0;
           const cnotify_me = await knex('product_notify_me')
           .where('varient_id', ProductList.varient_id)
           .where('user_id', user_id);
            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
            const subprod = await knex('store_orders')
            .select('store_orders.percentage')
            .where('store_orders.varient_id',ProductList.varient_id)
            .where('store_approval',user_id)
            .where('store_orders.subscription_flag',1)
            .where('store_orders.order_cart_id', "incart")
            .first();
            if(subprod){
              isSubscription = 'true'
            }else{
              isSubscription = 'false'
            }
           }else{
            notifyMe='false';
            isFavourite='false';
            cartQty=0;
            isSubscription = 'false'
           }
           const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
           const finalsubprice =  ProductList.mrp - sub_price;
           const subscription_price = parseFloat(finalsubprice.toFixed(2));
           const baseurl =  process.env.BUNNY_NET_IMAGE;
             if(ProductList.country_icon == null){
                countryicon = null
             }else{
                countryicon =  baseurl + ProductList.country_icon
             }
            if (Number.isInteger(price)) {
            priceval = price + '.001'
            }else{
            priceval = price
            }
            if (Number.isInteger(ProductList.mrp)) {
            mrpval = ProductList.mrp + '.001'
            }else{
            mrpval = ProductList.mrp
            }
        if(ProductList.fcat_id != null){
            fcatinput = ProductList.fcat_id;
            const resultArray = fcatinput.split(',').map(Number);
            const ftaglist = await knex('feature_categories')
                      .whereIn('id', resultArray)
                      .where('status',1)
                      .where('is_deleted', 0)
                      .select('id',knex.raw(`CONCAT('${baseurl}', image) as image`))
            feature_tags  = ftaglist;
          }else{
            feature_tags = [];
          }
           const customizedProduct = {
               stock: ProductList.stock,
               varient_id: ProductList.varient_id,
               product_id: ProductList.product_id,
               product_name: ProductList.product_name,
               product_image: baseurl + ProductList.product_image,
               thumbnail: baseurl + ProductList.thumbnail,
               description:ProductList.description,
               price: parseFloat(priceval),
               mrp: parseFloat(mrpval),
               unit: ProductList.unit,
               quantity: ProductList.quantity,
               type: ProductList.type,
               percentage: ProductList.percentage,
               isSubscription:isSubscription,
               subscription_price:subscription_price,
                availability:ProductList.availability,
              // discountper: ProductList.discountper,
               discountper:0,
               avgrating:0,
               notify_me: notifyMe,
               isFavourite: isFavourite,
               cart_qty: cartQty,
               countrating:0,
               country_icon : countryicon,
               feature_tags:feature_tags,
               varients:null
               // Add or modify properties as needed
               };
             customizedProductData.push(customizedProduct);
         }
         return customizedProductData
      const customizedItem = {
      id: item.id,
      title: item.title,
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      product_details:customizedProductData
      // Add or modify properties as needed
      };
      customizedData.push(customizedItem);
      }
    return customizedData;
};
  

module.exports = {
getUniversalSearch,
getSearchbystore,
getrecentSearch,
gettrenproducts,
getSearchbybanner,
getSearchbyBrands,
gettrendbrands,
getSearchbypopup
};